/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.registry;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.commons.concurrent.ConcurrentHashSet;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.registry.NotifyEvent;
import com.github.ltsopensource.core.registry.NotifyListener;
import com.github.ltsopensource.core.registry.Registry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractRegistry
implements Registry {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Registry.class);
    private final Set<Node> registered = new ConcurrentHashSet<Node>();
    private final ConcurrentMap<Node, Set<NotifyListener>> subscribed = new ConcurrentHashMap<Node, Set<NotifyListener>>();
    protected AppContext appContext;
    private Node node;

    public AbstractRegistry(AppContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public void register(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("register node == null");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Register: " + node);
        }
        this.registered.add(node);
    }

    @Override
    public void unregister(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("unregister node == null");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Unregister: " + node);
        }
        this.registered.remove(node);
    }

    @Override
    public void subscribe(Node node, NotifyListener listener) {
        Set listeners;
        if (node == null) {
            throw new IllegalArgumentException("subscribe node == null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("subscribe listener == null");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Subscribe: " + node);
        }
        if ((listeners = (Set)this.subscribed.get(node)) == null) {
            this.subscribed.putIfAbsent(node, new ConcurrentHashSet());
            listeners = (Set)this.subscribed.get(node);
        }
        listeners.add(listener);
    }

    @Override
    public void unsubscribe(Node node, NotifyListener listener) {
        Set listeners;
        if (node == null) {
            throw new IllegalArgumentException("unsubscribe node == null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("unsubscribe listener == null");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("unsubscribe: " + node);
        }
        if ((listeners = (Set)this.subscribed.get(node)) != null) {
            listeners.remove(listener);
        }
    }

    protected void notify(NotifyEvent event, List<Node> nodes, NotifyListener listener) {
        if (event == null) {
            throw new IllegalArgumentException("notify event == null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("notify listener == null");
        }
        if (CollectionUtils.isEmpty(nodes)) {
            LOGGER.warn("Ignore empty notify nodes for subscribe node " + this.getNode());
            return;
        }
        listener.notify(event, nodes);
    }

    @Override
    public void destroy() {
        HashMap<Node, Set<NotifyListener>> destroySubscribed;
        HashSet<Node> destroyRegistered;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroy registry:" + this.getNode());
        }
        if (!(destroyRegistered = new HashSet<Node>(this.getRegistered())).isEmpty()) {
            for (Node node : new HashSet<Node>(this.getRegistered())) {
                try {
                    this.unregister(node);
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("Destroy unregister node " + node);
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to unregister node " + node + " to registry " + this.getNode() + " on destroy, cause: " + t.getMessage(), t);
                }
            }
        }
        if (!(destroySubscribed = new HashMap<Node, Set<NotifyListener>>(this.getSubscribed())).isEmpty()) {
            for (Map.Entry entry : destroySubscribed.entrySet()) {
                Node node = (Node)entry.getKey();
                for (NotifyListener listener : (Set)entry.getValue()) {
                    try {
                        this.unsubscribe(node, listener);
                        if (!LOGGER.isInfoEnabled()) continue;
                        LOGGER.info("Destroy unsubscribe node " + node);
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Failed to unsubscribe node " + node + " to registry " + this.getNode() + " on destroy, cause: " + t.getMessage(), t);
                    }
                }
            }
        }
    }

    protected Set<Node> getRegistered() {
        return this.registered;
    }

    protected ConcurrentMap<Node, Set<NotifyListener>> getSubscribed() {
        return this.subscribed;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    protected void recover() throws Exception {
        HashMap<Node, Set<NotifyListener>> recoverSubscribed;
        HashSet<Node> recoverRegistered = new HashSet<Node>(this.getRegistered());
        if (!recoverRegistered.isEmpty()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Recover register node " + recoverRegistered);
            }
            for (Node node : recoverRegistered) {
                this.register(node);
            }
        }
        if (!(recoverSubscribed = new HashMap<Node, Set<NotifyListener>>(this.getSubscribed())).isEmpty()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Recover subscribe node " + recoverSubscribed.keySet());
            }
            for (Map.Entry entry : recoverSubscribed.entrySet()) {
                Node node = (Node)entry.getKey();
                for (NotifyListener listener : (Set)entry.getValue()) {
                    this.subscribe(node, listener);
                }
            }
        }
    }
}

