/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.registry;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.commons.concurrent.ConcurrentHashSet;
import com.github.ltsopensource.core.commons.utils.Callable;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.registry.AbstractRegistry;
import com.github.ltsopensource.core.registry.NotifyEvent;
import com.github.ltsopensource.core.registry.NotifyListener;
import com.github.ltsopensource.core.support.NodeShutdownHook;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class FailbackRegistry
extends AbstractRegistry {
    private final ScheduledExecutorService retryExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("LTSRegistryFailedRetryTimer", true));
    private ScheduledFuture<?> retryFuture;
    private final Set<Node> failedRegistered = new ConcurrentHashSet<Node>();
    private final Set<Node> failedUnRegistered = new ConcurrentHashSet<Node>();
    private final ConcurrentMap<Node, Set<NotifyListener>> failedSubscribed = new ConcurrentHashMap<Node, Set<NotifyListener>>();
    private final ConcurrentMap<Node, Set<NotifyListener>> failedUnsubscribed = new ConcurrentHashMap<Node, Set<NotifyListener>>();
    private final ConcurrentMap<Node, Map<NotifyListener, NotifyPair<NotifyEvent, List<Node>>>> failedNotified = new ConcurrentHashMap<Node, Map<NotifyListener, NotifyPair<NotifyEvent, List<Node>>>>();

    public FailbackRegistry(AppContext appContext) {
        super(appContext);
        int retryPeriod = appContext.getConfig().getParameter("retry.period", 5000);
        this.retryFuture = this.retryExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    FailbackRegistry.this.retry();
                }
                catch (Throwable t) {
                    AbstractRegistry.LOGGER.error("Unexpected error occur at failed retry, cause: " + t.getMessage(), t);
                }
            }
        }, retryPeriod, retryPeriod, TimeUnit.MILLISECONDS);
        NodeShutdownHook.registerHook(appContext, this.getClass().getName(), new Callable(){

            @Override
            public void call() throws Exception {
                FailbackRegistry.this.retryFuture.cancel(true);
                FailbackRegistry.this.retryExecutor.shutdownNow();
                FailbackRegistry.this.destroy();
            }
        });
    }

    @Override
    public void register(Node node) {
        try {
            super.register(node);
            this.failedRegistered.clear();
            this.doRegister(node);
        }
        catch (Exception e) {
            this.failedRegistered.add(node);
        }
    }

    @Override
    public void unregister(Node node) {
        try {
            super.unregister(node);
            this.failedUnRegistered.clear();
            this.doUnRegister(node);
        }
        catch (Exception e) {
            this.failedUnRegistered.add(node);
        }
    }

    @Override
    public void subscribe(Node node, NotifyListener listener) {
        try {
            super.subscribe(node, listener);
            this.removeFailedSubscribed(node, listener);
            this.doSubscribe(node, listener);
        }
        catch (Exception e) {
            this.addFailedSubscribed(node, listener);
        }
    }

    @Override
    public void unsubscribe(Node node, NotifyListener listener) {
        try {
            super.unsubscribe(node, listener);
            this.removeFailedSubscribed(node, listener);
            this.doUnsubscribe(node, listener);
        }
        catch (Exception e) {
            this.addFailedUnsubscribed(node, listener);
        }
    }

    protected void addFailedUnsubscribed(Node node, NotifyListener listener) {
        Set listeners = (Set)this.failedUnsubscribed.get(node);
        if (listeners == null) {
            this.failedUnsubscribed.putIfAbsent(node, new ConcurrentHashSet());
            listeners = (Set)this.failedUnsubscribed.get(node);
        }
        listeners.add(listener);
    }

    @Override
    protected void notify(NotifyEvent event, List<Node> nodes, NotifyListener listener) {
        try {
            super.notify(event, nodes, listener);
        }
        catch (Exception e) {
            Map listeners = (Map)this.failedNotified.get(this.getNode());
            if (listeners == null) {
                this.failedNotified.putIfAbsent(this.getNode(), new ConcurrentHashMap());
                listeners = (Map)this.failedNotified.get(this.getNode());
            }
            listeners.put(listener, new NotifyPair<NotifyEvent, List<Node>>(event, nodes));
            LOGGER.error("Failed to notify, waiting for retry, cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.retryFuture.cancel(true);
        }
        catch (Throwable t) {
            LOGGER.warn(t.getMessage(), t);
        }
    }

    @Override
    protected void recover() throws Exception {
        HashMap<Node, Set<NotifyListener>> recoverSubscribed;
        HashSet<Node> recoverRegistered = new HashSet<Node>(this.getRegistered());
        if (!recoverRegistered.isEmpty()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Recover register node " + recoverRegistered);
            }
            for (Node node : recoverRegistered) {
                this.failedRegistered.add(node);
            }
        }
        if (!(recoverSubscribed = new HashMap<Node, Set<NotifyListener>>(this.getSubscribed())).isEmpty()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Recover subscribe node " + recoverSubscribed.keySet());
            }
            for (Map.Entry entry : recoverSubscribed.entrySet()) {
                Node node = (Node)entry.getKey();
                for (NotifyListener listener : (Set)entry.getValue()) {
                    this.addFailedSubscribed(node, listener);
                }
            }
        }
    }

    private void removeFailedSubscribed(Node node, NotifyListener listener) {
        Map notified;
        Set listeners = (Set)this.failedSubscribed.get(node);
        if (listeners != null) {
            listeners.remove(listener);
        }
        if ((listeners = (Set)this.failedUnsubscribed.get(node)) != null) {
            listeners.remove(listener);
        }
        if ((notified = (Map)this.failedNotified.get(node)) != null) {
            notified.remove(listener);
        }
    }

    private void addFailedSubscribed(Node node, NotifyListener listener) {
        Set listeners = (Set)this.failedSubscribed.get(node);
        if (listeners == null) {
            this.failedSubscribed.putIfAbsent(node, new ConcurrentHashSet());
            listeners = (Set)this.failedSubscribed.get(node);
        }
        listeners.add(listener);
    }

    protected void retry() {
        Set listeners;
        Node node;
        Iterator<Object> i$;
        Cloneable failed;
        if (!this.failedRegistered.isEmpty() && (failed = new HashSet<Node>(this.failedRegistered)).size() > 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Retry register {}", failed);
            }
            try {
                i$ = failed.iterator();
                while (i$.hasNext()) {
                    Node node2 = (Node)i$.next();
                    this.doRegister(node2);
                    this.failedRegistered.remove(node2);
                }
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to retry register " + failed + ", waiting for again, cause: " + t.getMessage(), t);
            }
        }
        if (!this.failedUnRegistered.isEmpty() && (failed = new HashSet<Node>(this.failedUnRegistered)).size() > 0) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Retry unregister {}", failed);
            }
            try {
                i$ = failed.iterator();
                while (i$.hasNext()) {
                    Node node3 = (Node)i$.next();
                    this.doUnRegister(node3);
                    this.failedUnRegistered.remove(node3);
                }
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to retry unregister " + failed + ", waiting for again, cause: " + t.getMessage(), t);
            }
        }
        if (!this.failedSubscribed.isEmpty()) {
            failed = new HashMap<Node, Set<NotifyListener>>(this.failedSubscribed);
            for (Map.Entry entry : new HashMap(failed).entrySet()) {
                if (entry.getValue() != null && ((Set)entry.getValue()).size() != 0) continue;
                failed.remove(entry.getKey());
            }
            if (failed.size() > 0) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Retry subscribe " + failed);
                }
                try {
                    for (Map.Entry entry : failed.entrySet()) {
                        node = (Node)entry.getKey();
                        listeners = (Set)entry.getValue();
                        for (NotifyListener listener : listeners) {
                            try {
                                this.doSubscribe(node, listener);
                                listeners.remove(listener);
                                this.failedSubscribed.remove(entry.getKey());
                            }
                            catch (Throwable t) {
                                LOGGER.warn("Failed to retry subscribe " + failed + ", waiting for again, cause: " + t.getMessage(), t);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to retry subscribe " + failed + ", waiting for again, cause: " + t.getMessage(), t);
                }
            }
        }
        if (!this.failedUnsubscribed.isEmpty()) {
            failed = new HashMap<Node, Set<NotifyListener>>(this.failedUnsubscribed);
            for (Map.Entry entry : new HashMap(failed).entrySet()) {
                if (entry.getValue() != null && ((Set)entry.getValue()).size() != 0) continue;
                failed.remove(entry.getKey());
            }
            if (failed.size() > 0) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Retry unsubscribe " + failed);
                }
                try {
                    for (Map.Entry entry : failed.entrySet()) {
                        node = (Node)entry.getKey();
                        listeners = (Set)entry.getValue();
                        for (NotifyListener listener : listeners) {
                            try {
                                this.doUnsubscribe(node, listener);
                                listeners.remove(listener);
                            }
                            catch (Throwable t) {
                                LOGGER.warn("Failed to retry unsubscribe " + failed + ", waiting for again, cause: " + t.getMessage(), t);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to retry unsubscribe " + failed + ", waiting for again, cause: " + t.getMessage(), t);
                }
            }
        }
        if (!this.failedNotified.isEmpty()) {
            failed = new HashMap<Node, Map<NotifyListener, NotifyPair<NotifyEvent, List<Node>>>>(this.failedNotified);
            for (Map.Entry entry : new HashMap(failed).entrySet()) {
                if (entry.getValue() != null && ((Map)entry.getValue()).size() != 0) continue;
                failed.remove(entry.getKey());
            }
            if (failed.size() > 0) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Retry notify " + failed);
                }
                try {
                    for (Map map : failed.values()) {
                        for (Map.Entry entry : map.entrySet()) {
                            try {
                                NotifyListener listener = (NotifyListener)entry.getKey();
                                NotifyPair notifyPair = (NotifyPair)entry.getValue();
                                listener.notify((NotifyEvent)((Object)notifyPair.event), (List)notifyPair.nodes);
                                map.remove(listener);
                            }
                            catch (Throwable t) {
                                LOGGER.warn("Failed to retry notify " + failed + ", waiting for again, cause: " + t.getMessage(), t);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to retry notify " + failed + ", waiting for again, cause: " + t.getMessage(), t);
                }
            }
        }
    }

    protected abstract void doRegister(Node var1);

    protected abstract void doUnRegister(Node var1);

    protected abstract void doSubscribe(Node var1, NotifyListener var2);

    protected abstract void doUnsubscribe(Node var1, NotifyListener var2);

    private class NotifyPair<T1, T2> {
        T1 event;
        T2 nodes;

        public NotifyPair(T1 event, T2 nodes) {
            this.event = event;
            this.nodes = nodes;
        }
    }
}

