/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobclient.processor;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.protocol.JobProtos;
import com.github.ltsopensource.core.protocol.command.JobFinishedRequest;
import com.github.ltsopensource.jobclient.domain.JobClientAppContext;
import com.github.ltsopensource.jobclient.support.JobClientMStatReporter;
import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.RemotingProcessor;
import com.github.ltsopensource.remoting.exception.RemotingCommandException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;

public class JobFinishedProcessor
implements RemotingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobFinishedProcessor.class);
    private JobClientAppContext appContext;
    private JobClientMStatReporter stat;

    public JobFinishedProcessor(JobClientAppContext appContext) {
        this.appContext = appContext;
        this.stat = (JobClientMStatReporter)appContext.getMStatReporter();
    }

    @Override
    public RemotingCommand processRequest(Channel Channel2, RemotingCommand request) throws RemotingCommandException {
        JobFinishedRequest requestBody = (JobFinishedRequest)request.getBody();
        try {
            if (this.appContext.getJobCompletedHandler() != null) {
                this.appContext.getJobCompletedHandler().onComplete(requestBody.getJobResults());
                this.stat.incHandleFeedbackNum(CollectionUtils.sizeOf(requestBody.getJobResults()));
            }
        }
        catch (Exception t) {
            LOGGER.error(t.getMessage(), t);
        }
        return RemotingCommand.createResponseCommand(JobProtos.ResponseCode.JOB_NOTIFY_SUCCESS.code(), "received successful");
    }
}

