/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.complete;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.domain.Job;
import com.github.ltsopensource.core.domain.JobMeta;
import com.github.ltsopensource.core.domain.JobRunResult;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.core.support.CronExpressionUtils;
import com.github.ltsopensource.core.support.JobUtils;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jobtracker.complete.retry.DefaultJobRetryTimeGenerator;
import com.github.ltsopensource.jobtracker.complete.retry.JobRetryTimeGenerator;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import java.util.Date;
import java.util.List;

public class JobRetryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRetryHandler.class);
    private JobTrackerAppContext appContext;
    private int retryInterval = 30000;
    private JobRetryTimeGenerator jobRetryTimeGenerator;

    public JobRetryHandler(JobTrackerAppContext appContext) {
        this.appContext = appContext;
        this.retryInterval = appContext.getConfig().getParameter("jobtracker.job.retry.interval.millis", 30000);
        this.jobRetryTimeGenerator = ServiceLoader.load(JobRetryTimeGenerator.class, appContext.getConfig());
    }

    public void onComplete(List<JobRunResult> results) {
        if (CollectionUtils.isEmpty(results)) {
            return;
        }
        for (JobRunResult result : results) {
            JobMeta jobMeta = result.getJobMeta();
            JobPo jobPo = this.appContext.getExecutingJobQueue().getJob(jobMeta.getJobId());
            if (jobPo == null) continue;
            Job job = jobMeta.getJob();
            if (!(this.jobRetryTimeGenerator instanceof DefaultJobRetryTimeGenerator)) {
                job = JobUtils.copy(jobMeta.getJob());
                job.setTaskId(jobMeta.getRealTaskId());
            }
            Long nextRetryTriggerTime = this.jobRetryTimeGenerator.getNextRetryTriggerTime(job, jobPo.getRetryTimes(), this.retryInterval);
            jobPo.setRetryTimes((jobPo.getRetryTimes() == null ? 0 : jobPo.getRetryTimes()) + 1);
            if (jobPo.isCron()) {
                JobPo cronJobPo = this.appContext.getCronJobQueue().getJob(jobMeta.getJobId());
                if (cronJobPo != null) {
                    Date nextTriggerTime = CronExpressionUtils.getNextTriggerTime(cronJobPo.getCronExpression());
                    if (nextTriggerTime != null && nextTriggerTime.getTime() < nextRetryTriggerTime) {
                        nextRetryTriggerTime = nextTriggerTime.getTime();
                        jobPo = cronJobPo;
                    } else {
                        jobPo.setInternalExtParam("__LTS_Is_Retry_Job", Boolean.TRUE.toString());
                    }
                }
            } else if (jobPo.isRepeatable()) {
                JobPo repeatJobPo = this.appContext.getRepeatJobQueue().getJob(jobMeta.getJobId());
                if (repeatJobPo != null && (repeatJobPo.getRepeatCount() == -1 || repeatJobPo.getRepeatedCount() < repeatJobPo.getRepeatCount())) {
                    long nexTriggerTime = JobUtils.getRepeatNextTriggerTime(jobPo);
                    if (nexTriggerTime < nextRetryTriggerTime) {
                        nextRetryTriggerTime = nexTriggerTime;
                        jobPo = repeatJobPo;
                    } else {
                        jobPo.setInternalExtParam("__LTS_Is_Retry_Job", Boolean.TRUE.toString());
                    }
                }
            } else {
                jobPo.setInternalExtParam("__LTS_Is_Retry_Job", Boolean.TRUE.toString());
            }
            jobPo.setTaskTrackerIdentity(null);
            jobPo.setIsRunning(false);
            jobPo.setGmtModified(SystemClock.now());
            jobPo.setTriggerTime(nextRetryTriggerTime);
            try {
                this.appContext.getExecutableJobQueue().add(jobPo);
            }
            catch (DupEntryException e) {
                LOGGER.warn("ExecutableJobQueue already exist:" + JSON.toJSONString(jobPo));
            }
            this.appContext.getExecutingJobQueue().remove(jobPo.getJobId());
        }
    }
}

