/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.support;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.Holder;
import com.github.ltsopensource.core.domain.Action;
import com.github.ltsopensource.core.domain.Job;
import com.github.ltsopensource.core.domain.JobResult;
import com.github.ltsopensource.core.domain.JobRunResult;
import com.github.ltsopensource.core.exception.RemotingSendException;
import com.github.ltsopensource.core.exception.RequestTimeoutException;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.protocol.JobProtos;
import com.github.ltsopensource.core.protocol.command.JobFinishedRequest;
import com.github.ltsopensource.core.remoting.RemotingServerDelegate;
import com.github.ltsopensource.core.support.JobUtils;
import com.github.ltsopensource.jobtracker.domain.JobClientNode;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.support.ClientNotifyHandler;
import com.github.ltsopensource.remoting.AsyncCallback;
import com.github.ltsopensource.remoting.ResponseFuture;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ClientNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientNotifier.class.getSimpleName());
    private ClientNotifyHandler clientNotifyHandler;
    private JobTrackerAppContext appContext;

    public ClientNotifier(JobTrackerAppContext appContext, ClientNotifyHandler clientNotifyHandler) {
        this.appContext = appContext;
        this.clientNotifyHandler = clientNotifyHandler;
    }

    public <T extends JobRunResult> int send(List<T> jobResults) {
        if (CollectionUtils.isEmpty(jobResults)) {
            return 0;
        }
        if (jobResults.size() == 1) {
            JobRunResult result = (JobRunResult)jobResults.get(0);
            if (!this.send0(result.getJobMeta().getJob().getSubmitNodeGroup(), Collections.singletonList(result))) {
                this.clientNotifyHandler.handleFailed(jobResults);
                return 0;
            }
        } else if (jobResults.size() > 1) {
            ArrayList failedJobRunResult = new ArrayList();
            HashMap<String, ArrayList<JobRunResult>> groupMap = new HashMap<String, ArrayList<JobRunResult>>();
            for (JobRunResult jobRunResult : jobResults) {
                ArrayList<JobRunResult> results = (ArrayList<JobRunResult>)groupMap.get(jobRunResult.getJobMeta().getJob().getSubmitNodeGroup());
                if (results == null) {
                    results = new ArrayList<JobRunResult>();
                    groupMap.put(jobRunResult.getJobMeta().getJob().getSubmitNodeGroup(), results);
                }
                results.add(jobRunResult);
            }
            for (Map.Entry entry : groupMap.entrySet()) {
                if (this.send0((String)entry.getKey(), (List)entry.getValue())) continue;
                failedJobRunResult.addAll((Collection)entry.getValue());
            }
            this.clientNotifyHandler.handleFailed(failedJobRunResult);
            return jobResults.size() - failedJobRunResult.size();
        }
        return jobResults.size();
    }

    private boolean send0(String nodeGroup, final List<JobRunResult> results) {
        JobClientNode jobClientNode = this.appContext.getJobClientManager().getAvailableJobClient(nodeGroup);
        if (jobClientNode == null) {
            return false;
        }
        ArrayList<JobResult> jobResults = new ArrayList<JobResult>(results.size());
        for (JobRunResult result : results) {
            JobResult jobResult = new JobResult();
            Job job = JobUtils.copy(result.getJobMeta().getJob());
            job.setTaskId(result.getJobMeta().getRealTaskId());
            jobResult.setJob(job);
            jobResult.setSuccess(Action.EXECUTE_SUCCESS.equals((Object)result.getAction()));
            jobResult.setMsg(result.getMsg());
            jobResult.setTime(result.getTime());
            jobResult.setExeSeqId(result.getJobMeta().getInternalExtParam("__LTS_Seq_Id"));
            jobResults.add(jobResult);
        }
        JobFinishedRequest requestBody = this.appContext.getCommandBodyWrapper().wrapper(new JobFinishedRequest());
        requestBody.setJobResults(jobResults);
        RemotingCommand commandRequest = RemotingCommand.createRequestCommand(JobProtos.RequestCode.JOB_COMPLETED.code(), requestBody);
        final Holder result = new Holder();
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            this.getRemotingServer().invokeAsync(jobClientNode.getChannel().getChannel(), commandRequest, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(ResponseFuture responseFuture) {
                    try {
                        RemotingCommand commandResponse = responseFuture.getResponseCommand();
                        if (commandResponse != null && commandResponse.getCode() == JobProtos.ResponseCode.JOB_NOTIFY_SUCCESS.code()) {
                            ClientNotifier.this.clientNotifyHandler.handleSuccess(results);
                            result.set(true);
                        } else {
                            result.set(false);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await(60000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RequestTimeoutException(e);
            }
        }
        catch (RemotingSendException e) {
            LOGGER.error("Notify client failed!", e);
        }
        return result.get() == null ? false : (Boolean)result.get();
    }

    private RemotingServerDelegate getRemotingServer() {
        return this.appContext.getRemotingServer();
    }
}

