/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.json.deserializer;

import com.github.ltsopensource.json.JSONException;
import com.github.ltsopensource.json.JSONObject;
import com.github.ltsopensource.json.deserializer.Deserializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MapDeserializer
implements Deserializer {
    public static final MapDeserializer INSTANCE = new MapDeserializer();

    @Override
    public <T> T deserialize(Object object, Type type) {
        Map<Object, Object> map = this.createMap(type);
        if (object instanceof Map) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            return (T)map;
        }
        if (object instanceof JSONObject) {
            JSONObject json = (JSONObject)object;
            for (Map.Entry<String, Object> entry : json.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            return (T)map;
        }
        throw new JSONException("illegal object class:" + object.getClass() + " type:" + type);
    }

    protected Map<Object, Object> createMap(Type type) {
        if (type == Properties.class) {
            return new Properties();
        }
        if (type == Hashtable.class) {
            return new Hashtable<Object, Object>();
        }
        if (type == IdentityHashMap.class) {
            return new IdentityHashMap<Object, Object>();
        }
        if (type == SortedMap.class || type == TreeMap.class) {
            return new TreeMap<Object, Object>();
        }
        if (type == ConcurrentMap.class || type == ConcurrentHashMap.class) {
            return new ConcurrentHashMap<Object, Object>();
        }
        if (type == Map.class || type == HashMap.class) {
            return new HashMap<Object, Object>();
        }
        if (type == LinkedHashMap.class) {
            return new LinkedHashMap<Object, Object>();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.createMap(parameterizedType.getRawType());
        }
        Class clazz = (Class)type;
        if (clazz.isInterface()) {
            throw new JSONException("unsupported type " + type);
        }
        try {
            return (Map)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JSONException("unsupported type " + type, e);
        }
    }
}

