/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.data;

import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.commons.io.UnsafeByteArrayInputStream;
import com.github.ltsopensource.core.commons.io.UnsafeByteArrayOutputStream;
import com.github.ltsopensource.core.json.TypeReference;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.kv.CapacityNotEnoughException;
import com.github.ltsopensource.kv.DB;
import com.github.ltsopensource.kv.DBException;
import com.github.ltsopensource.kv.StoreConfig;
import com.github.ltsopensource.kv.data.DataAppendResult;
import com.github.ltsopensource.kv.data.DataBlock;
import com.github.ltsopensource.kv.data.DataCompactor;
import com.github.ltsopensource.kv.data.DataEntry;
import com.github.ltsopensource.kv.index.IndexItem;
import com.github.ltsopensource.kv.serializer.StoreSerializer;
import com.github.ltsopensource.kv.txlog.StoreTxLogPosition;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class DataBlockEngine<K, V> {
    private static final Logger LOGGER = DB.LOGGER;
    private final ConcurrentMap<Long, DataBlock> NAME_BLOCK_MAP = new ConcurrentHashMap<Long, DataBlock>();
    private CopyOnWriteArrayList<DataBlock> writableBlocks = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<DataBlock> readonlyBlocks = new CopyOnWriteArrayList();
    private StoreSerializer serializer;
    private File dataPath;
    private StoreConfig storeConfig;
    private ReentrantLock lock = new ReentrantLock();
    private DataCompactor dataCompactor;

    public DataBlockEngine(StoreSerializer serializer, StoreConfig storeConfig) {
        this.serializer = serializer;
        this.storeConfig = storeConfig;
        this.dataPath = storeConfig.getDataPath();
    }

    public void init() throws IOException {
        try {
            FileUtils.createDirIfNotExist(this.dataPath);
        }
        catch (IOException e) {
            LOGGER.error("create dataPath " + this.dataPath + " error:" + e.getMessage(), e);
            throw e;
        }
        String[] dataFiles = this.dataPath.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".ltsdata");
            }
        });
        if (dataFiles.length == 0) {
            return;
        }
        StoreTxLogPosition maxTxLog = null;
        for (String dataFile : dataFiles) {
            try {
                DataBlock dataBlock = new DataBlock(dataFile, this.storeConfig);
                this.NAME_BLOCK_MAP.put(dataBlock.getFileId(), dataBlock);
                if (dataBlock.isFull()) {
                    this.readonlyBlocks.add(dataBlock);
                } else {
                    this.writableBlocks.add(dataBlock);
                }
                if (maxTxLog != null && maxTxLog.getRecordId() >= dataBlock.getLastTxLogPosition().getRecordId()) continue;
                maxTxLog = dataBlock.getLastTxLogPosition();
            }
            catch (IOException e) {
                LOGGER.error("load data block [" + dataFile + "] error:" + e.getMessage(), e);
            }
        }
        this.storeConfig.setLastTxLogPositionOnDataBlock(maxTxLog);
    }

    protected List<DataBlock> getReadonlyBlocks() {
        return this.readonlyBlocks;
    }

    public DataAppendResult append(StoreTxLogPosition storeTxLogPosition, K key, V value) {
        UnsafeByteArrayOutputStream out = new UnsafeByteArrayOutputStream();
        try {
            DataEntry<K, V> dataEntry = new DataEntry<K, V>(key, value);
            this.serializer.serialize(dataEntry, out);
            DataAppendResult dataAppendResult = this.append(storeTxLogPosition, out.toByteArray());
            return dataAppendResult;
        }
        catch (Exception e) {
            throw new DBException("Persistent data error: " + e.getMessage(), e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ignored) {}
        }
    }

    public V getValue(IndexItem<K> index) {
        try {
            DataBlock dataBlock = (DataBlock)this.NAME_BLOCK_MAP.get(index.getFileId());
            if (dataBlock == null) {
                return null;
            }
            byte[] data = dataBlock.readData(index.getFromIndex(), index.getLength());
            UnsafeByteArrayInputStream is = new UnsafeByteArrayInputStream(data);
            DataEntry dataEntry = (DataEntry)this.serializer.deserialize(is, new TypeReference<DataEntry<K, V>>(){}.getType());
            return dataEntry.getValue();
        }
        catch (Exception e) {
            throw new DBException("Read data error: " + e.getMessage(), e);
        }
    }

    public void remove(StoreTxLogPosition storeTxLogPosition, IndexItem<K> index) {
        DataBlock dataBlock = (DataBlock)this.NAME_BLOCK_MAP.get(index.getFileId());
        if (dataBlock == null) {
            return;
        }
        dataBlock.removeData(storeTxLogPosition, index.getFromIndex(), index.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataBlock getWriteDataBlock() throws IOException {
        if (this.writableBlocks.size() != 0) {
            return this.writableBlocks.get(0);
        }
        this.lock.lock();
        try {
            if (this.writableBlocks.size() != 0) {
                DataBlock dataBlock = this.writableBlocks.get(0);
                return dataBlock;
            }
            DataBlock dataBlock = new DataBlock(this.storeConfig);
            this.NAME_BLOCK_MAP.put(dataBlock.getFileId(), dataBlock);
            this.writableBlocks.add(dataBlock);
            DataBlock dataBlock2 = dataBlock;
            return dataBlock2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private DataAppendResult append(StoreTxLogPosition storeTxLogPosition, byte[] dataBytes) throws IOException {
        DataBlock writeBlock = this.getWriteDataBlock();
        try {
            return writeBlock.append(storeTxLogPosition, dataBytes);
        }
        catch (CapacityNotEnoughException e) {
            if (!this.readonlyBlocks.contains(writeBlock)) {
                this.readonlyBlocks.add(writeBlock);
            }
            this.writableBlocks.remove(writeBlock);
            return this.append(storeTxLogPosition, dataBytes);
        }
    }
}

