/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.kv.index;

import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.kv.DB;
import com.github.ltsopensource.kv.StoreConfig;
import com.github.ltsopensource.kv.index.Index;
import com.github.ltsopensource.kv.index.IndexSnapshot;
import com.github.ltsopensource.kv.serializer.StoreSerializer;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractIndexSnapshot<K, V>
implements IndexSnapshot<K, V> {
    protected static final Logger LOGGER = DB.LOGGER;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> future;
    protected Index<K, V> index;
    protected StoreSerializer serializer;
    protected StoreConfig storeConfig;

    public AbstractIndexSnapshot(Index<K, V> index, StoreConfig storeConfig, StoreSerializer serializer) {
        this.index = index;
        this.storeConfig = storeConfig;
        this.serializer = serializer;
        this.executorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("ltsdb-index-snapshot-service", true));
    }

    @Override
    public void init() throws IOException {
        this.loadFromDisk();
        this.replayTxLog();
        this.future = this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractIndexSnapshot.this.snapshot();
                }
                catch (Throwable t) {
                    LOGGER.error("MemIndexSnapshot snapshot error:" + t.getMessage(), t);
                }
            }
        }, this.storeConfig.getIndexSnapshotInterval(), this.storeConfig.getIndexSnapshotInterval(), TimeUnit.MILLISECONDS);
    }

    protected abstract void loadFromDisk() throws IOException;

    protected abstract void replayTxLog();
}

