/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.mina;

import com.github.ltsopensource.remoting.AbstractRemotingServer;
import com.github.ltsopensource.remoting.ChannelEventListener;
import com.github.ltsopensource.remoting.RemotingServerConfig;
import com.github.ltsopensource.remoting.exception.RemotingException;
import com.github.ltsopensource.remoting.mina.MinaCodecFactory;
import com.github.ltsopensource.remoting.mina.MinaHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.MdcInjectionFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;

public class MinaRemotingServer
extends AbstractRemotingServer {
    private IoAcceptor acceptor;
    private InetSocketAddress bindAddress;

    public MinaRemotingServer(RemotingServerConfig remotingServerConfig) {
        this(remotingServerConfig, null);
    }

    public MinaRemotingServer(RemotingServerConfig remotingServerConfig, ChannelEventListener channelEventListener) {
        super(remotingServerConfig, channelEventListener);
    }

    @Override
    protected void serverStart() throws RemotingException {
        this.acceptor = new NioSocketAcceptor();
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new MinaCodecFactory(this.getCodec())));
        this.acceptor.getFilterChain().addLast("mdc", (IoFilter)new MdcInjectionFilter());
        this.acceptor.setHandler((IoHandler)new MinaHandler(this));
        IoSessionConfig cfg = this.acceptor.getSessionConfig();
        cfg.setReaderIdleTime(this.remotingServerConfig.getReaderIdleTimeSeconds());
        cfg.setWriterIdleTime(this.remotingServerConfig.getWriterIdleTimeSeconds());
        cfg.setBothIdleTime(this.remotingServerConfig.getServerChannelMaxIdleTimeSeconds());
        this.bindAddress = new InetSocketAddress(this.remotingServerConfig.getListenPort());
        try {
            this.acceptor.bind((SocketAddress)this.bindAddress);
        }
        catch (IOException e) {
            throw new RemotingException("Start Mina server error", e);
        }
    }

    @Override
    protected void serverShutdown() throws RemotingException {
        if (this.acceptor != null) {
            this.acceptor.unbind((SocketAddress)this.bindAddress);
            this.acceptor.dispose();
        }
    }
}

