/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring;

import com.github.ltsopensource.autoconfigure.PropertiesConfigurationFactory;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.listener.MasterChangeListener;
import com.github.ltsopensource.core.properties.TaskTrackerProperties;
import com.github.ltsopensource.tasktracker.TaskTracker;
import com.github.ltsopensource.tasktracker.TaskTrackerBuilder;
import com.github.ltsopensource.tasktracker.runner.JobRunner;
import com.github.ltsopensource.tasktracker.runner.RunnerFactory;
import java.util.Properties;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class TaskTrackerXmlFactoryBean
implements FactoryBean<TaskTracker>,
InitializingBean,
DisposableBean {
    private TaskTracker taskTracker;
    private boolean started;
    private String clusterName;
    private String nodeGroup;
    private String registryAddress;
    private String dataPath;
    private String identity;
    private String bindIp;
    private int workThreads;
    private Level bizLoggerLevel;
    private MasterChangeListener[] masterChangeListeners;
    private Properties configs = new Properties();
    private String[] locations;

    public TaskTracker getObject() throws Exception {
        return this.taskTracker;
    }

    public Class<?> getObjectType() {
        return TaskTracker.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        TaskTrackerProperties properties = null;
        if (this.locations == null || this.locations.length == 0) {
            properties = new TaskTrackerProperties();
            properties.setClusterName(this.clusterName);
            properties.setDataPath(this.dataPath);
            properties.setNodeGroup(this.nodeGroup);
            properties.setRegistryAddress(this.registryAddress);
            properties.setBindIp(this.bindIp);
            properties.setIdentity(this.identity);
            properties.setBizLoggerLevel(this.bizLoggerLevel);
            properties.setWorkThreads(this.workThreads);
            properties.setConfigs(CollectionUtils.toMap(this.configs));
        } else {
            properties = PropertiesConfigurationFactory.createPropertiesConfiguration(TaskTrackerProperties.class, this.locations);
        }
        this.taskTracker = TaskTrackerBuilder.buildByProperties(properties);
        this.taskTracker.setRunnerFactory(new RunnerFactory(){

            @Override
            public JobRunner newRunner() {
                return TaskTrackerXmlFactoryBean.this.createJobRunner();
            }
        });
        if (this.masterChangeListeners != null) {
            for (MasterChangeListener masterChangeListener : this.masterChangeListeners) {
                this.taskTracker.addMasterChangeListener(masterChangeListener);
            }
        }
    }

    public void start() {
        if (!this.started) {
            this.taskTracker.start();
            this.started = true;
        }
    }

    protected abstract JobRunner createJobRunner();

    public void destroy() throws Exception {
        this.taskTracker.stop();
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setWorkThreads(int workThreads) {
        this.workThreads = workThreads;
    }

    public void setMasterChangeListeners(MasterChangeListener ... masterChangeListeners) {
        this.masterChangeListeners = masterChangeListeners;
    }

    public void setBizLoggerLevel(String bizLoggerLevel) {
        if (StringUtils.isNotEmpty(bizLoggerLevel)) {
            this.bizLoggerLevel = Level.valueOf(bizLoggerLevel);
        }
    }

    public void setConfigs(Properties configs) {
        this.configs = configs;
    }

    public void setBindIp(String bindIp) {
        this.bindIp = bindIp;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setLocations(String ... locations) {
        this.locations = locations;
    }
}

