/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.jdbc;

import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.exception.LtsRuntimeException;
import com.github.ltsopensource.store.jdbc.SqlTemplate;
import com.github.ltsopensource.store.jdbc.SqlTemplateFactory;
import com.github.ltsopensource.store.jdbc.exception.JdbcException;
import java.io.IOException;
import java.io.InputStream;

public abstract class JdbcAbstractAccess {
    private SqlTemplate sqlTemplate;

    public JdbcAbstractAccess(Config config) {
        this.sqlTemplate = SqlTemplateFactory.create(config);
    }

    public SqlTemplate getSqlTemplate() {
        return this.sqlTemplate;
    }

    protected String readSqlFile(String path) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        try {
            return FileUtils.read(is, "UTF-8");
        }
        catch (IOException e) {
            throw new LtsRuntimeException("Read sql file : [" + path + "] error ", e);
        }
    }

    protected String readSqlFile(String path, String tableName) {
        String sql = this.readSqlFile(path);
        return sql.replace("{tableName}", tableName);
    }

    protected void createTable(String sql) throws JdbcException {
        try {
            this.getSqlTemplate().createTable(sql);
        }
        catch (Exception e) {
            throw new JdbcException("Create table error, sql=" + sql, e);
        }
    }
}

