/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.mongo;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.List;

public class MongoFactoryBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoFactoryBean.class);
    private List<ServerAddress> replicaSetSeeds = new ArrayList<ServerAddress>();
    private MongoClientOptions mongoClientOptions;
    private List<MongoCredential> mongoCredentials = new ArrayList<MongoCredential>();

    public MongoFactoryBean(String[] serverAddresses) {
        this.replSeeds(serverAddresses);
    }

    public MongoFactoryBean(String[] serverAddresses, String username, String database, String pwd) {
        this(serverAddresses, MongoCredential.MONGODB_CR_MECHANISM, username, database, pwd);
    }

    public MongoFactoryBean(String[] serverAddresses, String mechanism, String username, String database, String pwd) {
        this.replSeeds(serverAddresses);
        if (StringUtils.isNotEmpty(username)) {
            if (MongoCredential.GSSAPI_MECHANISM.equals(mechanism)) {
                this.mongoCredentials.add(MongoCredential.createGSSAPICredential((String)username));
            } else {
                this.mongoCredentials.add(MongoCredential.createMongoCRCredential((String)username, (String)database, (char[])pwd.toCharArray()));
            }
        }
    }

    public MongoFactoryBean(String[] serverAddresses, MongoClientOptions mongoClientOptions) {
        this(serverAddresses);
        this.mongoClientOptions = mongoClientOptions;
    }

    public MongoClient createInstance() throws Exception {
        if (this.replicaSetSeeds.size() > 0) {
            if (this.mongoClientOptions != null) {
                if (this.mongoCredentials != null) {
                    return new MongoClient(this.replicaSetSeeds, this.mongoCredentials, this.mongoClientOptions);
                }
                return new MongoClient(this.replicaSetSeeds, this.mongoClientOptions);
            }
            if (this.mongoCredentials != null) {
                return new MongoClient(this.replicaSetSeeds, this.mongoCredentials);
            }
            return new MongoClient(this.replicaSetSeeds);
        }
        return new MongoClient();
    }

    private void replSeeds(String ... serverAddresses) {
        try {
            this.replicaSetSeeds.clear();
            for (String addr : serverAddresses) {
                String[] a = addr.split(":");
                String host = a[0];
                if (a.length > 2) {
                    throw new IllegalArgumentException("Invalid Server Address : " + addr);
                }
                if (a.length == 2) {
                    this.replicaSetSeeds.add(new ServerAddress(host, Integer.parseInt(a[1])));
                    continue;
                }
                this.replicaSetSeeds.add(new ServerAddress(host));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
    }
}

