/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker.processor;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.commons.utils.Callable;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.domain.JobMeta;
import com.github.ltsopensource.core.domain.JobRunResult;
import com.github.ltsopensource.core.exception.JobTrackerNotFoundException;
import com.github.ltsopensource.core.exception.RequestTimeoutException;
import com.github.ltsopensource.core.failstore.FailStorePathBuilder;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.protocol.JobProtos;
import com.github.ltsopensource.core.protocol.command.JobCompletedRequest;
import com.github.ltsopensource.core.protocol.command.JobPushRequest;
import com.github.ltsopensource.core.protocol.command.JobPushResponse;
import com.github.ltsopensource.core.remoting.RemotingClientDelegate;
import com.github.ltsopensource.core.support.NodeShutdownHook;
import com.github.ltsopensource.core.support.RetryScheduler;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.remoting.AsyncCallback;
import com.github.ltsopensource.remoting.Channel;
import com.github.ltsopensource.remoting.ResponseFuture;
import com.github.ltsopensource.remoting.exception.RemotingCommandException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import com.github.ltsopensource.remoting.protocol.RemotingProtos;
import com.github.ltsopensource.tasktracker.domain.Response;
import com.github.ltsopensource.tasktracker.domain.TaskTrackerAppContext;
import com.github.ltsopensource.tasktracker.expcetion.NoAvailableJobRunnerException;
import com.github.ltsopensource.tasktracker.processor.AbstractProcessor;
import com.github.ltsopensource.tasktracker.runner.RunnerCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class JobPushProcessor
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobPushProcessor.class);
    private RetryScheduler<JobRunResult> retryScheduler;
    private JobRunnerCallback jobRunnerCallback;
    private RemotingClientDelegate remotingClient;

    protected JobPushProcessor(TaskTrackerAppContext appContext) {
        super(appContext);
        this.remotingClient = appContext.getRemotingClient();
        this.jobRunnerCallback = new JobRunnerCallback();
        if (this.isEnableFailStore()) {
            this.retryScheduler = new RetryScheduler<JobRunResult>(JobPushProcessor.class.getSimpleName(), (AppContext)appContext, FailStorePathBuilder.getJobFeedbackPath(appContext), 3){

                @Override
                protected boolean isRemotingEnable() {
                    return JobPushProcessor.this.remotingClient.isServerEnable();
                }

                @Override
                protected boolean retry(List<JobRunResult> results) {
                    return JobPushProcessor.this.retrySendJobResults(results);
                }
            };
            this.retryScheduler.start();
            NodeShutdownHook.registerHook(appContext, this.getClass().getName(), new Callable(){

                @Override
                public void call() throws Exception {
                    JobPushProcessor.this.retryScheduler.stop();
                }
            });
        }
    }

    @Override
    public RemotingCommand processRequest(Channel channel, RemotingCommand request) throws RemotingCommandException {
        JobPushRequest requestBody = (JobPushRequest)request.getBody();
        List<JobMeta> jobMetaList = requestBody.getJobMetaList();
        ArrayList<String> failedJobIds = null;
        for (JobMeta jobMeta : jobMetaList) {
            try {
                this.appContext.getRunnerPool().execute(jobMeta, this.jobRunnerCallback);
            }
            catch (NoAvailableJobRunnerException e) {
                if (failedJobIds == null) {
                    failedJobIds = new ArrayList<String>();
                }
                failedJobIds.add(jobMeta.getJobId());
            }
        }
        if (CollectionUtils.isNotEmpty(failedJobIds)) {
            JobPushResponse jobPushResponse = new JobPushResponse();
            jobPushResponse.setFailedJobIds(failedJobIds);
            return RemotingCommand.createResponseCommand(JobProtos.ResponseCode.NO_AVAILABLE_JOB_RUNNER.code(), jobPushResponse);
        }
        return RemotingCommand.createResponseCommand(JobProtos.ResponseCode.JOB_PUSH_SUCCESS.code(), "job push success!");
    }

    private boolean isEnableFailStore() {
        return !this.appContext.getConfig().getParameter("lts.task.tracker.job.result.failstore.close", false);
    }

    private boolean retrySendJobResults(List<JobRunResult> results) {
        JobCompletedRequest requestBody = this.appContext.getCommandBodyWrapper().wrapper(new JobCompletedRequest());
        requestBody.setJobRunResults(results);
        requestBody.setReSend(true);
        int requestCode = JobProtos.RequestCode.JOB_COMPLETED.code();
        RemotingCommand request = RemotingCommand.createRequestCommand(requestCode, requestBody);
        try {
            RemotingCommand commandResponse = this.remotingClient.invokeSync(request);
            if (commandResponse != null && commandResponse.getCode() == RemotingProtos.ResponseCode.SUCCESS.code()) {
                return true;
            }
            LOGGER.warn("Send job failed, {}", commandResponse);
            return false;
        }
        catch (JobTrackerNotFoundException e) {
            LOGGER.error("Retry send job result failed! jobResults={}", results, e);
            return false;
        }
    }

    private class JobRunnerCallback
    implements RunnerCallback {
        private JobRunnerCallback() {
        }

        @Override
        public JobMeta runComplete(Response response) {
            final JobRunResult jobRunResult = new JobRunResult();
            jobRunResult.setTime(SystemClock.now());
            jobRunResult.setJobMeta(response.getJobMeta());
            jobRunResult.setAction(response.getAction());
            jobRunResult.setMsg(response.getMsg());
            JobCompletedRequest requestBody = JobPushProcessor.this.appContext.getCommandBodyWrapper().wrapper(new JobCompletedRequest());
            requestBody.addJobResult(jobRunResult);
            requestBody.setReceiveNewJob(response.isReceiveNewJob());
            int requestCode = JobProtos.RequestCode.JOB_COMPLETED.code();
            RemotingCommand request = RemotingCommand.createRequestCommand(requestCode, requestBody);
            final Response returnResponse = new Response();
            try {
                final CountDownLatch latch = new CountDownLatch(1);
                JobPushProcessor.this.remotingClient.invokeAsync(request, new AsyncCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void operationComplete(ResponseFuture responseFuture) {
                        block11: {
                            try {
                                RemotingCommand commandResponse = responseFuture.getResponseCommand();
                                if (commandResponse != null && commandResponse.getCode() == RemotingProtos.ResponseCode.SUCCESS.code()) {
                                    JobPushRequest jobPushRequest = (JobPushRequest)commandResponse.getBody();
                                    if (jobPushRequest != null) {
                                        if (LOGGER.isDebugEnabled()) {
                                            LOGGER.debug("Get new job :{}", JSON.toJSONString(jobPushRequest.getJobMetaList()));
                                        }
                                        if (CollectionUtils.isNotEmpty(jobPushRequest.getJobMetaList())) {
                                            returnResponse.setJobMeta(jobPushRequest.getJobMetaList().get(0));
                                        }
                                    }
                                    break block11;
                                }
                                if (LOGGER.isInfoEnabled()) {
                                    LOGGER.info("Job feedback failed, save local files\u3002{}", jobRunResult);
                                }
                                try {
                                    if (JobPushProcessor.this.isEnableFailStore()) {
                                        JobPushProcessor.this.retryScheduler.inSchedule(jobRunResult.getJobMeta().getJobId().concat("_") + SystemClock.now(), jobRunResult);
                                        break block11;
                                    }
                                    LOGGER.error("Send Job Result to JobTracker Error, code={}, jobRunResult={}", commandResponse != null ? Integer.valueOf(commandResponse.getCode()) : null, JSON.toJSONString(jobRunResult));
                                }
                                catch (Exception e) {
                                    LOGGER.error("Job feedback failed", e);
                                }
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    }
                });
                try {
                    latch.await(60000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new RequestTimeoutException(e);
                }
            }
            catch (JobTrackerNotFoundException e) {
                try {
                    LOGGER.warn("No job tracker available! save local files.");
                    if (JobPushProcessor.this.isEnableFailStore()) {
                        JobPushProcessor.this.retryScheduler.inSchedule(jobRunResult.getJobMeta().getJobId().concat("_") + SystemClock.now(), jobRunResult);
                    } else {
                        LOGGER.error("Send Job Result to JobTracker Error, server is down, jobRunResult={}", JSON.toJSONString(jobRunResult));
                    }
                }
                catch (Exception e1) {
                    LOGGER.error("Save files failed, {}", jobRunResult.getJobMeta(), e1);
                }
            }
            return returnResponse.getJobMeta();
        }
    }
}

