/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.enums.QrcodeType;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.api.response.QrcodeResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import com.github.sd4324530.fastweixin.util.StrUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrcodeAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(QrcodeAPI.class);

    public QrcodeAPI(ApiConfig config) {
        super(config);
    }

    public QrcodeResponse createQrcode(QrcodeType actionName, String sceneId, Integer expireSeconds) {
        return this.createQrcode(actionName, sceneId, null, expireSeconds);
    }

    public QrcodeResponse createQrcode(QrcodeType actionName, String sceneId, String sceneStr, Integer expireSeconds) {
        BaseResponse r;
        BeanUtil.requireNonNull((Object)actionName, "actionName is null");
        BeanUtil.requireNonNull(sceneId, "actionInfo is null");
        LOG.debug("\u521b\u5efa\u4e8c\u7ef4\u7801\u4fe1\u606f.....");
        QrcodeResponse response = null;
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("action_name", (Object)actionName);
        HashMap actionInfo = new HashMap();
        HashMap<String, String> scene = new HashMap<String, String>();
        if (StrUtil.isNotBlank(sceneId)) {
            scene.put("scene_id", sceneId);
        }
        if (StrUtil.isNotBlank(sceneStr)) {
            scene.put("scene_str", sceneStr);
        }
        actionInfo.put("scene", scene);
        param.put("action_info", actionInfo);
        if (BeanUtil.nonNull(expireSeconds) && 0 != expireSeconds) {
            param.put("expire_seconds", expireSeconds);
        }
        String resultJson = this.isSuccess((r = this.executePost(url, JSONUtil.toJson(param))).getErrcode()) ? r.getErrmsg() : r.toJsonString();
        response = JSONUtil.toBean(resultJson, QrcodeResponse.class);
        return response;
    }
}

