/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.company.api;

import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.company.api.QYBaseAPI;
import com.github.sd4324530.fastweixin.company.api.config.QYAPIConfig;
import com.github.sd4324530.fastweixin.company.api.entity.QYDepartment;
import com.github.sd4324530.fastweixin.company.api.enums.QYResultType;
import com.github.sd4324530.fastweixin.company.api.response.CreateDepartmentResponse;
import com.github.sd4324530.fastweixin.company.api.response.GetDepartmentListResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;

public class QYDepartmentAPI
extends QYBaseAPI {
    public QYDepartmentAPI(QYAPIConfig config) {
        super(config);
    }

    public GetDepartmentListResponse getList(Integer parentId) {
        String url = parentId != null ? "https://qyapi.weixin.qq.com/cgi-bin/department/list?access_token=#&id=" + parentId : "https://qyapi.weixin.qq.com/cgi-bin/department/list?access_token=#";
        BaseResponse r = this.executeGet(url);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetDepartmentListResponse response = JSONUtil.toBean(resultJson, GetDepartmentListResponse.class);
        return response;
    }

    public CreateDepartmentResponse create(QYDepartment department) {
        BeanUtil.requireNonNull(department, "department is null");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/create?access_token=#";
        BaseResponse r = this.executePost(url, department.toJsonString());
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        CreateDepartmentResponse response = JSONUtil.toBean(resultJson, CreateDepartmentResponse.class);
        return response;
    }

    public QYResultType update(QYDepartment department) {
        BeanUtil.requireNonNull(department, "department is null");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/update?access_token=#";
        BaseResponse r = this.executePost(url, department.toJsonString());
        return QYResultType.get(r.getErrcode());
    }

    public QYResultType delete(Integer id) {
        BeanUtil.requireNonNull(id, "id is null");
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/delete?access_token=#&id=" + id;
        BaseResponse r = this.executeGet(url);
        return QYResultType.get(r.getErrcode());
    }
}

