/*
 * Decompiled with CFR 0.152.
 */
package com.smartdoc.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.power.common.util.FileUtil;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.SourceCodePath;
import com.smartdoc.util.ClassLoaderUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class MojoUtils {
    public static final Gson GSON = new GsonBuilder().addDeserializationExclusionStrategy(new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> aClass) {
            return false;
        }
    }).create();

    public static ApiConfig buildConfig(File configFile, String projectName, MavenProject project, Log log) throws MojoExecutionException {
        try {
            ClassLoader classLoader = ClassLoaderUtil.getRuntimeClassLoader(project);
            String data = FileUtil.getFileContent((InputStream)new FileInputStream(configFile));
            ApiConfig apiConfig = (ApiConfig)GSON.fromJson(data, ApiConfig.class);
            List apiDataDictionaries = apiConfig.getDataDictionaries();
            List apiErrorCodes = apiConfig.getErrorCodeDictionaries();
            if (apiErrorCodes != null) {
                apiErrorCodes.forEach(apiErrorCode -> {
                    String className = apiErrorCode.getEnumClassName();
                    apiErrorCode.setEnumClass(MojoUtils.getClassByClassName(className, classLoader));
                });
            }
            if (apiDataDictionaries != null) {
                apiDataDictionaries.forEach(apiDataDictionary -> {
                    String className = apiDataDictionary.getEnumClassName();
                    apiDataDictionary.setEnumClass(MojoUtils.getClassByClassName(className, classLoader));
                });
            }
            if (StringUtils.isBlank((CharSequence)apiConfig.getProjectName())) {
                apiConfig.setProjectName(projectName);
            }
            MojoUtils.addSourcePaths(project, apiConfig, log);
            return apiConfig;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getClassByClassName(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addSourcePaths(MavenProject project, ApiConfig apiConfig, Log log) {
        File file;
        MavenProject mavenProject;
        List sourceRoots = project.getCompileSourceRoots();
        sourceRoots.forEach(s -> apiConfig.setSourceCodePaths(new SourceCodePath[]{SourceCodePath.path().setPath(s)}));
        if (project.hasParent() && null != (mavenProject = project.getParent()) && !Objects.isNull(file = mavenProject.getBasedir())) {
            apiConfig.setSourceCodePaths(new SourceCodePath[]{SourceCodePath.path().setPath(file.getPath())});
        }
    }
}

