/*
 * Decompiled with CFR 0.152.
 */
package com.github.snakerflow.plugin;

import java.util.Collections;
import java.util.HashMap;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Order
@Configuration
@ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseType.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@EnableTransactionManagement
public class TransactionManagerConfig {
    private static final String AOP_POINTCUT_EXPRESSION = "execution(* org.snaker.engine.core..*.*(..))";

    @Bean
    public TransactionInterceptor txAdvice(TransactionManager transactionManager) {
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        RuleBasedTransactionAttribute readOnlyTx = new RuleBasedTransactionAttribute();
        readOnlyTx.setReadOnly(true);
        readOnlyTx.setPropagationBehavior(0);
        RuleBasedTransactionAttribute requiredTx = new RuleBasedTransactionAttribute();
        requiredTx.setRollbackRules(Collections.singletonList(new RollbackRuleAttribute(Exception.class)));
        requiredTx.setPropagationBehavior(0);
        requiredTx.setTimeout(5);
        HashMap<String, RuleBasedTransactionAttribute> txMap = new HashMap<String, RuleBasedTransactionAttribute>();
        txMap.put("start*", requiredTx);
        txMap.put("execute*", requiredTx);
        txMap.put("save*", requiredTx);
        txMap.put("delete*", requiredTx);
        txMap.put("update*", requiredTx);
        txMap.put("remove*", requiredTx);
        txMap.put("assign*", requiredTx);
        txMap.put("create*", requiredTx);
        txMap.put("complete*", requiredTx);
        txMap.put("finish*", requiredTx);
        txMap.put("terminate*", requiredTx);
        txMap.put("do*", requiredTx);
        txMap.put("take*", requiredTx);
        txMap.put("deploy*", requiredTx);
        txMap.put("undeploy*", requiredTx);
        txMap.put("redeploy*", requiredTx);
        txMap.put("get*", readOnlyTx);
        txMap.put("find*", readOnlyTx);
        txMap.put("query*", readOnlyTx);
        txMap.put("search*", readOnlyTx);
        txMap.put("is*", readOnlyTx);
        txMap.put("*", requiredTx);
        source.setNameMap(txMap);
        return new TransactionInterceptor(transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor txAdviceAdvisor(TransactionInterceptor txAdvice) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(AOP_POINTCUT_EXPRESSION);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)txAdvice);
    }
}

