/*
 * Decompiled with CFR 0.152.
 */
package redis.util;

import java.util.Collection;
import java.util.TreeSet;
import redis.util.BytesKey;
import redis.util.BytesKeyObjectMap;
import redis.util.ZSetEntry;

public class BytesKeyZSet
extends TreeSet<ZSetEntry> {
    private BytesKeyObjectMap<ZSetEntry> map;

    public BytesKeyZSet() {
    }

    public BytesKeyZSet(BytesKeyZSet destination) {
        super(destination);
    }

    @Override
    public boolean add(ZSetEntry zSetEntry) {
        this.getMap().put(zSetEntry.getKey(), zSetEntry);
        return super.add(zSetEntry);
    }

    private BytesKeyObjectMap<ZSetEntry> getMap() {
        if (this.map == null) {
            this.map = new BytesKeyObjectMap();
        }
        return this.map;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof ZSetEntry) {
            ZSetEntry removed = this.getMap().remove(((ZSetEntry)o).getKey());
            return removed != null && super.remove(removed);
        }
        return super.remove(o);
    }

    public ZSetEntry get(BytesKey key) {
        return this.getMap().get(key);
    }

    public ZSetEntry get(byte[] key) {
        return this.getMap().get(new BytesKey(key));
    }

    @Override
    public boolean addAll(Collection<? extends ZSetEntry> c) {
        boolean changed = super.addAll(c);
        for (ZSetEntry zSetEntry : c) {
            this.getMap().put(zSetEntry.getKey(), zSetEntry);
        }
        return changed;
    }
}

