/*
 * Decompiled with CFR 0.152.
 */
package com.github.taccisum.swagger.configurer;

import com.github.taccisum.swagger.configurer.DescriptionBuilder;
import com.github.taccisum.swagger.configurer.DocketBuilderInterceptor;
import com.github.taccisum.swagger.configurer.concrete.DefaultDescriptionBuilder;
import com.github.taccisum.swagger.configurer.config.SwaggerProperties;
import com.github.taccisum.swagger.configurer.event.AfterInitializeDocketEvent;
import com.github.taccisum.swagger.configurer.event.BeforeInitializeDocketEvent;
import com.github.taccisum.swagger.configurer.util.PathsUtil;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.Ordered;
import org.springframework.util.CollectionUtils;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

public class DocketBuilder {
    private EventBus eventBus = new EventBus();
    private List<DocketBuilderInterceptor> interceptors = new ArrayList<DocketBuilderInterceptor>();
    private Docket instance = null;
    private SwaggerProperties properties;
    private DescriptionBuilder descriptionBuilder;

    public DocketBuilder(SwaggerProperties properties) {
        this.properties = properties;
        this.descriptionBuilder = new DefaultDescriptionBuilder(null, properties.getInfo().getDescription());
    }

    public void setDescriptionBuilder(DescriptionBuilder descriptionBuilder) {
        this.descriptionBuilder = descriptionBuilder;
    }

    public void addInterceptor(DocketBuilderInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public Docket build() {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = new Docket(DocumentationType.SWAGGER_2);
        this.registerInterceptors();
        this.eventBus.post((Object)new BeforeInitializeDocketEvent(this.instance));
        if (!this.properties.getEnabled().booleanValue()) {
            this.instance.enable(false);
            return this.instance;
        }
        if (CollectionUtils.isEmpty(this.properties.getIncludePaths())) {
            this.properties.setIncludePaths(Lists.newArrayList((Object[])new String[]{"/**"}));
        }
        HashMap schemeMap = new HashMap();
        HashMap contextMap = new HashMap();
        this.properties.getAuth().getApiKey().forEach((k, v) -> {
            schemeMap.put(k, new ApiKey(k, v.getKeyName(), v.getPassAs().val()));
            contextMap.put(k, SecurityContext.builder().securityReferences((List)Lists.newArrayList((Object[])new SecurityReference[]{SecurityReference.builder().scopes(new AuthorizationScope[0]).reference(k).build()})).forPaths(PathsUtil.includeAndExclude(v.getIncludePaths(), v.getExcludePaths())).build());
        });
        this.instance.apiInfo(this.apiInfo()).pathMapping(this.properties.getPathMapping()).genericModelSubstitutes(this.properties.getGenericModelSubstitutes().toArray(new Class[0])).enableUrlTemplating(this.properties.getEnableUrlTemplating().booleanValue()).select().apis(RequestHandlerSelectors.basePackage((String)this.properties.getBasePackage())).paths(PathsUtil.includeAndExclude(this.properties.getIncludePaths(), this.properties.getExcludePaths())).build().globalOperationParameters(this.gop()).securitySchemes(new ArrayList(schemeMap.values())).securityContexts(new ArrayList(contextMap.values()));
        this.eventBus.post((Object)new AfterInitializeDocketEvent(this.instance));
        return this.instance;
    }

    private void registerInterceptors() {
        this.interceptors.stream().sorted(Comparator.comparingInt(Ordered::getOrder)).forEach(i -> this.eventBus.register(i));
    }

    private List<Parameter> gop() {
        Map<String, SwaggerProperties.ParameterProperties> globalParameters = this.properties.getGlobalParameters();
        if (globalParameters != null && globalParameters.size() > 0) {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            globalParameters.forEach((k, v) -> {
                Parameter parameter = new ParameterBuilder().name(k).modelRef((ModelReference)new ModelRef(v.getModelRef())).parameterType(v.getParameterType()).required(v.getRequired().booleanValue()).defaultValue(v.getDefaultValue()).description(v.getDescription()).hidden(v.getHidden().booleanValue()).build();
                parameters.add(parameter);
            });
            return parameters;
        }
        return null;
    }

    private ApiInfo apiInfo() {
        SwaggerProperties.Info conf = this.properties.getInfo();
        return new ApiInfoBuilder().title(conf.getTitle()).description(this.descriptionBuilder.build()).version(conf.getVersion()).termsOfServiceUrl(conf.getTermsOfServiceUrl()).contact(new Contact(conf.getContact().getName(), conf.getContact().getUrl(), conf.getContact().getEmail())).license(conf.getLicense()).licenseUrl(conf.getLicenseUrl()).build();
    }
}

