/*
 * Decompiled with CFR 0.152.
 */
package com.github.taccisum.swagger.configurer.concrete;

import com.github.taccisum.swagger.configurer.DescriptionBuilder;
import com.github.taccisum.swagger.configurer.config.SwaggerProperties;
import com.github.taccisum.swagger.configurer.util.NetUtils;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.springframework.core.env.Environment;

public class DefaultDescriptionBuilder
implements DescriptionBuilder {
    private Environment env;
    private SwaggerProperties.Info.Description descConf;

    public DefaultDescriptionBuilder(Environment env, SwaggerProperties.Info.Description descConf) {
        this.env = env;
        this.descConf = descConf;
    }

    @Override
    public String build() {
        StringBuilder sb = new StringBuilder();
        if (this.descConf.getShowProfiles().booleanValue() && this.env != null) {
            sb.append("<br/>");
            sb.append("<span style='font-weight:bold'>Active profiles: </span>");
            Object[] activeProfiles = this.env.getActiveProfiles();
            if (activeProfiles.length == 0) {
                activeProfiles = new String[]{"default"};
            }
            sb.append(Arrays.toString(activeProfiles));
        }
        if (this.descConf.getShowStartDate().booleanValue()) {
            sb.append("<br/>");
            sb.append("<span style='font-weight:bold'>Start date: </span>");
            sb.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        if (this.descConf.getShowHostname().booleanValue()) {
            sb.append("<br/>");
            sb.append("<span style='font-weight:bold'>Hostname: </span>");
            sb.append(NetUtils.getHostName());
        }
        return sb.toString();
    }
}

