/*
 * Decompiled with CFR 0.152.
 */
package com.github.taccisum.swagger.configurer.config;

import com.github.taccisum.swagger.configurer.constant.PassAs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import springfox.documentation.swagger.web.DocExpansion;
import springfox.documentation.swagger.web.ModelRendering;
import springfox.documentation.swagger.web.OperationsSorter;
import springfox.documentation.swagger.web.TagsSorter;
import springfox.documentation.swagger.web.UiConfiguration;

@ConfigurationProperties(value="swagger")
public class SwaggerProperties {
    public static final String PREFIX = "swagger";
    private Boolean enabled = true;
    private String basePackage = null;
    private List<String> includePaths = new ArrayList<String>();
    private List<String> excludePaths = new ArrayList<String>();
    private String pathMapping = "/";
    private List<Class> genericModelSubstitutes = new ArrayList<Class>();
    private Boolean enableUrlTemplating = false;
    private AuthProperties auth = new AuthProperties();
    private Info info = new Info();
    private Map<String, ParameterProperties> globalParameters = new HashMap<String, ParameterProperties>();
    private UIProperties ui = new UIProperties();

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public List<String> getIncludePaths() {
        return this.includePaths;
    }

    public List<String> getExcludePaths() {
        return this.excludePaths;
    }

    public String getPathMapping() {
        return this.pathMapping;
    }

    public List<Class> getGenericModelSubstitutes() {
        return this.genericModelSubstitutes;
    }

    public Boolean getEnableUrlTemplating() {
        return this.enableUrlTemplating;
    }

    public AuthProperties getAuth() {
        return this.auth;
    }

    public Info getInfo() {
        return this.info;
    }

    public Map<String, ParameterProperties> getGlobalParameters() {
        return this.globalParameters;
    }

    public UIProperties getUi() {
        return this.ui;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setIncludePaths(List<String> includePaths) {
        this.includePaths = includePaths;
    }

    public void setExcludePaths(List<String> excludePaths) {
        this.excludePaths = excludePaths;
    }

    public void setPathMapping(String pathMapping) {
        this.pathMapping = pathMapping;
    }

    public void setGenericModelSubstitutes(List<Class> genericModelSubstitutes) {
        this.genericModelSubstitutes = genericModelSubstitutes;
    }

    public void setEnableUrlTemplating(Boolean enableUrlTemplating) {
        this.enableUrlTemplating = enableUrlTemplating;
    }

    public void setAuth(AuthProperties auth) {
        this.auth = auth;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public void setGlobalParameters(Map<String, ParameterProperties> globalParameters) {
        this.globalParameters = globalParameters;
    }

    public void setUi(UIProperties ui) {
        this.ui = ui;
    }

    public static class UIProperties {
        private Boolean deepLinking = true;
        private Boolean displayOperationId = false;
        private Integer defaultModelsExpandDepth = 1;
        private Integer defaultModelExpandDepth = 1;
        private ModelRendering defaultModelRendering = ModelRendering.EXAMPLE;
        private Boolean displayRequestDuration = false;
        private DocExpansion docExpansion = DocExpansion.NONE;
        private Boolean filter = false;
        private Integer maxDisplayedTags;
        private OperationsSorter operationsSorter = OperationsSorter.ALPHA;
        private Boolean showExtensions = false;
        private TagsSorter tagsSorter = TagsSorter.ALPHA;
        private String[] supportedSubmitMethods = UiConfiguration.Constants.DEFAULT_SUBMIT_METHODS;
        private String validatorUrl;

        public Boolean getDeepLinking() {
            return this.deepLinking;
        }

        public Boolean getDisplayOperationId() {
            return this.displayOperationId;
        }

        public Integer getDefaultModelsExpandDepth() {
            return this.defaultModelsExpandDepth;
        }

        public Integer getDefaultModelExpandDepth() {
            return this.defaultModelExpandDepth;
        }

        public ModelRendering getDefaultModelRendering() {
            return this.defaultModelRendering;
        }

        public Boolean getDisplayRequestDuration() {
            return this.displayRequestDuration;
        }

        public DocExpansion getDocExpansion() {
            return this.docExpansion;
        }

        public Boolean getFilter() {
            return this.filter;
        }

        public Integer getMaxDisplayedTags() {
            return this.maxDisplayedTags;
        }

        public OperationsSorter getOperationsSorter() {
            return this.operationsSorter;
        }

        public Boolean getShowExtensions() {
            return this.showExtensions;
        }

        public TagsSorter getTagsSorter() {
            return this.tagsSorter;
        }

        public String[] getSupportedSubmitMethods() {
            return this.supportedSubmitMethods;
        }

        public String getValidatorUrl() {
            return this.validatorUrl;
        }

        public void setDeepLinking(Boolean deepLinking) {
            this.deepLinking = deepLinking;
        }

        public void setDisplayOperationId(Boolean displayOperationId) {
            this.displayOperationId = displayOperationId;
        }

        public void setDefaultModelsExpandDepth(Integer defaultModelsExpandDepth) {
            this.defaultModelsExpandDepth = defaultModelsExpandDepth;
        }

        public void setDefaultModelExpandDepth(Integer defaultModelExpandDepth) {
            this.defaultModelExpandDepth = defaultModelExpandDepth;
        }

        public void setDefaultModelRendering(ModelRendering defaultModelRendering) {
            this.defaultModelRendering = defaultModelRendering;
        }

        public void setDisplayRequestDuration(Boolean displayRequestDuration) {
            this.displayRequestDuration = displayRequestDuration;
        }

        public void setDocExpansion(DocExpansion docExpansion) {
            this.docExpansion = docExpansion;
        }

        public void setFilter(Boolean filter) {
            this.filter = filter;
        }

        public void setMaxDisplayedTags(Integer maxDisplayedTags) {
            this.maxDisplayedTags = maxDisplayedTags;
        }

        public void setOperationsSorter(OperationsSorter operationsSorter) {
            this.operationsSorter = operationsSorter;
        }

        public void setShowExtensions(Boolean showExtensions) {
            this.showExtensions = showExtensions;
        }

        public void setTagsSorter(TagsSorter tagsSorter) {
            this.tagsSorter = tagsSorter;
        }

        public void setSupportedSubmitMethods(String[] supportedSubmitMethods) {
            this.supportedSubmitMethods = supportedSubmitMethods;
        }

        public void setValidatorUrl(String validatorUrl) {
            this.validatorUrl = validatorUrl;
        }
    }

    public static class AuthProperties {
        private Map<String, ApiKeySecurityProperties> apiKey = new HashMap<String, ApiKeySecurityProperties>();

        public Map<String, ApiKeySecurityProperties> getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(Map<String, ApiKeySecurityProperties> apiKey) {
            this.apiKey = apiKey;
        }

        public static class ApiKeySecurityProperties {
            private String keyName;
            private PassAs passAs;
            private List<String> includePaths = new ArrayList<String>();
            private List<String> excludePaths = new ArrayList<String>();

            public String getKeyName() {
                return this.keyName;
            }

            public PassAs getPassAs() {
                return this.passAs;
            }

            public List<String> getIncludePaths() {
                return this.includePaths;
            }

            public List<String> getExcludePaths() {
                return this.excludePaths;
            }

            public void setKeyName(String keyName) {
                this.keyName = keyName;
            }

            public void setPassAs(PassAs passAs) {
                this.passAs = passAs;
            }

            public void setIncludePaths(List<String> includePaths) {
                this.includePaths = includePaths;
            }

            public void setExcludePaths(List<String> excludePaths) {
                this.excludePaths = excludePaths;
            }
        }
    }

    public static class ParameterProperties {
        private String modelRef = "string";
        private String parameterType = "query";
        private Boolean required = false;
        private String defaultValue;
        private String description = "global operation parameter";
        private Boolean hidden = false;

        public String getModelRef() {
            return this.modelRef;
        }

        public String getParameterType() {
            return this.parameterType;
        }

        public Boolean getRequired() {
            return this.required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getHidden() {
            return this.hidden;
        }

        public void setModelRef(String modelRef) {
            this.modelRef = modelRef;
        }

        public void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        public void setRequired(Boolean required) {
            this.required = required;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setHidden(Boolean hidden) {
            this.hidden = hidden;
        }
    }

    public static class Info {
        private String title;
        private String version;
        private Contact contact = new Contact();
        private String termsOfServiceUrl;
        private String license;
        private String licenseUrl;
        private Description description = new Description();

        public String getTitle() {
            return this.title;
        }

        public String getVersion() {
            return this.version;
        }

        public Contact getContact() {
            return this.contact;
        }

        public String getTermsOfServiceUrl() {
            return this.termsOfServiceUrl;
        }

        public String getLicense() {
            return this.license;
        }

        public String getLicenseUrl() {
            return this.licenseUrl;
        }

        public Description getDescription() {
            return this.description;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setContact(Contact contact) {
            this.contact = contact;
        }

        public void setTermsOfServiceUrl(String termsOfServiceUrl) {
            this.termsOfServiceUrl = termsOfServiceUrl;
        }

        public void setLicense(String license) {
            this.license = license;
        }

        public void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        public void setDescription(Description description) {
            this.description = description;
        }

        public static class Contact {
            private String name;
            private String url;
            private String email;

            public String getName() {
                return this.name;
            }

            public String getUrl() {
                return this.url;
            }

            public String getEmail() {
                return this.email;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public void setEmail(String email) {
                this.email = email;
            }
        }

        public static class Description {
            private String html;
            private Boolean showProfiles = true;
            private Boolean showStartDate = true;
            private Boolean showHostname = true;

            public String getHtml() {
                return this.html;
            }

            public Boolean getShowProfiles() {
                return this.showProfiles;
            }

            public Boolean getShowStartDate() {
                return this.showStartDate;
            }

            public Boolean getShowHostname() {
                return this.showHostname;
            }

            public void setHtml(String html) {
                this.html = html;
            }

            public void setShowProfiles(Boolean showProfiles) {
                this.showProfiles = showProfiles;
            }

            public void setShowStartDate(Boolean showStartDate) {
                this.showStartDate = showStartDate;
            }

            public void setShowHostname(Boolean showHostname) {
                this.showHostname = showHostname;
            }
        }
    }
}

