/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.conn;

import com.github.tobato.fastdfs.conn.Connection;
import com.github.tobato.fastdfs.conn.ConnectionManager;
import com.github.tobato.fastdfs.conn.FdfsConnectionPool;
import com.github.tobato.fastdfs.domain.TrackerLocator;
import com.github.tobato.fastdfs.exception.FdfsConnectException;
import com.github.tobato.fastdfs.proto.FdfsCommand;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="fdfs")
public class TrackerConnectionManager
extends ConnectionManager {
    private TrackerLocator trackerLocator;
    @NotNull
    private List<String> trackerList = new ArrayList<String>();

    public TrackerConnectionManager() {
    }

    public TrackerConnectionManager(FdfsConnectionPool pool) {
        super(pool);
    }

    @PostConstruct
    public void initTracker() {
        LOGGER.debug("init trackerLocator {}", this.trackerList);
        this.trackerLocator = new TrackerLocator(this.trackerList);
    }

    public <T> T executeFdfsTrackerCmd(FdfsCommand<T> command) {
        Connection conn = null;
        InetSocketAddress address = null;
        try {
            address = this.trackerLocator.getTrackerAddress();
            LOGGER.debug("\u83b7\u53d6\u5230Tracker\u8fde\u63a5\u5730\u5740{}", (Object)address);
            conn = this.getConnection(address);
            this.trackerLocator.setActive(address);
        }
        catch (FdfsConnectException e) {
            this.trackerLocator.setInActive(address);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unable to borrow buffer from pool", (Throwable)e);
            throw new RuntimeException("Unable to borrow buffer from pool", e);
        }
        return this.execute(address, conn, command);
    }

    public List<String> getTrackerList() {
        return this.trackerList;
    }

    public void setTrackerList(List<String> trackerList) {
        this.trackerList = trackerList;
    }
}

