/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.list;

import com.github.weisj.darklaf.delegate.ListCellRendererDelegate;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;

public class DarkListCellRendererDelegate
extends ListCellRendererDelegate<Object>
implements SwingConstants {
    public DarkListCellRendererDelegate() {
        super(null);
    }

    @Override
    public void setDelegate(ListCellRenderer<Object> delegate) {
        if (delegate == null) {
            super.setDelegate(new DefaultListCellRenderer());
        } else {
            super.setDelegate(delegate);
        }
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label;
        boolean focus;
        boolean isEditing = PropertyUtil.getBooleanProperty(list, (String)"JList.isEditing");
        boolean leadIndex = isEditing && list.getSelectionModel().getLeadSelectionIndex() == index;
        boolean sel = isSelected && !leadIndex;
        Component renderer = super.getListCellRendererComponent(list, value, index, sel, focus = cellHasFocus && !leadIndex);
        if (renderer instanceof JLabel && (label = (JLabel)renderer).getText().isEmpty()) {
            label.setText(" ");
        }
        CellUtil.setupListBackground(renderer, list, isSelected, index);
        CellUtil.setupListForeground(renderer, list, isSelected);
        return renderer;
    }
}

