/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tree;

import com.github.weisj.darklaf.components.tree.LabeledTreeNode;
import com.github.weisj.darklaf.components.tristate.TristateButtonModel;
import com.github.weisj.darklaf.components.tristate.TristateCheckBox;
import com.github.weisj.darklaf.components.tristate.TristateState;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.tree.DarkTreeCellRendererDelegate;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.ButtonModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreeCellEditor;

public class DarkTreeCellEditor
extends DefaultCellEditor
implements TreeCellEditor,
FocusListener {
    private static final JCheckBox dummyCheckBox = new JCheckBox();
    private JTree tree;

    public DarkTreeCellEditor(JTextField textField) {
        super(textField);
        textField.setBorder(UIManager.getBorder("Tree.editorBorder"));
        textField.addFocusListener(this);
        textField.putClientProperty("JComponent.isTreeEditor", true);
    }

    public DarkTreeCellEditor(JCheckBox checkBox) {
        this((JToggleButton)checkBox);
    }

    public DarkTreeCellEditor(final JToggleButton toggleButton) {
        super(dummyCheckBox);
        this.editorComponent = toggleButton;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public Object getCellEditorValue() {
                return toggleButton.isSelected();
            }

            @Override
            public void setValue(Object value) {
                Object unwrapped = DarkTreeCellRendererDelegate.unwrapValue(value);
                if (unwrapped instanceof TristateState && toggleButton instanceof TristateCheckBox) {
                    ((TristateCheckBox)toggleButton).setState((TristateState)((Object)unwrapped));
                } else {
                    toggleButton.setSelected(Boolean.TRUE.equals(unwrapped));
                }
                if (value instanceof LabeledTreeNode) {
                    toggleButton.setText(((LabeledTreeNode)value).getLabel());
                }
            }
        };
        toggleButton.setFocusPainted(false);
        toggleButton.putClientProperty("JComponent.isTreeEditor", Boolean.TRUE);
        toggleButton.addActionListener(this.delegate);
        toggleButton.setRequestFocusEnabled(false);
        toggleButton.addFocusListener(this);
        this.setClickCountToStart(1);
    }

    public DarkTreeCellEditor(JComboBox<?> comboBox) {
        super(comboBox);
        comboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (DarkTreeCellEditor.this.tree != null) {
                    DarkTreeCellEditor.this.tree.repaint();
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (DarkTreeCellEditor.this.tree != null) {
                    DarkTreeCellEditor.this.tree.repaint();
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        comboBox.putClientProperty("JComponent.isTreeEditor", Boolean.TRUE);
        comboBox.addFocusListener(this);
        this.setClickCountToStart(2);
    }

    public DarkTreeCellEditor(final JSpinner spinner) {
        super(dummyCheckBox);
        this.editorComponent = spinner;
        this.editorComponent.putClientProperty("JComponent.isTreeEditor", Boolean.TRUE);
        this.editorComponent.addFocusListener(this);
        this.setClickCountToStart(2);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public Object getCellEditorValue() {
                return spinner.getValue();
            }

            @Override
            public void setValue(Object value) {
                try {
                    SpinnerModel model = spinner.getModel();
                    if (model instanceof SpinnerNumberModel) {
                        spinner.setValue(NumberFormat.getInstance().parse(value.toString()));
                    } else if (model instanceof SpinnerDateModel) {
                        spinner.setValue(DateFormat.getInstance().parse(value.toString()));
                    } else {
                        spinner.setValue(value);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }
        };
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.tree = tree;
        this.delegate.setValue(value);
        if (this.editorComponent instanceof JComboBox) {
            ((JComboBox)this.editorComponent).removeAllItems();
            ((JComboBox)this.editorComponent).addItem(value);
            ((JComboBox)this.editorComponent).setSelectedItem(value);
        } else if (this.editorComponent instanceof JToggleButton) {
            ButtonModel model = ((JToggleButton)this.editorComponent).getModel();
            if (model instanceof TristateButtonModel) {
                ((TristateButtonModel)model).iterateState();
            } else {
                model.setSelected(!model.isSelected());
            }
            SwingUtilities.invokeLater(tree::stopEditing);
        }
        this.editorComponent.setOpaque(true);
        this.editorComponent.setComponentOrientation(tree.getComponentOrientation());
        CellUtil.setupTreeBackground(this.editorComponent, tree, false, row);
        CellUtil.setupTreeForeground(this.editorComponent, tree, false);
        return this.editorComponent;
    }

    protected void updateFocus(FocusEvent e) {
        CellUtil.setupTreeForeground(this.editorComponent, this.tree, false);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.updateFocus(null);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.updateFocus(e);
    }
}

