/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.holiday;

import com.xkzhangsan.time.LunarDate;
import com.xkzhangsan.time.converter.DateTimeConverterUtil;
import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import com.xkzhangsan.time.holiday.ChineseHolidayEnum;
import com.xkzhangsan.time.holiday.LocalHolidayEnum;
import com.xkzhangsan.time.utils.CollectionUtil;
import com.xkzhangsan.time.utils.StringUtil;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public interface Holiday {
    public static String getLocalHoliday(Date date) {
        return Holiday.getLocalHoliday(date, null);
    }

    public static String getLocalHoliday(Date date, Map<String, String> localHolidayMap) {
        Objects.requireNonNull(date, "date");
        return Holiday.getLocalHoliday(DateTimeConverterUtil.toLocalDateTime(date), localHolidayMap);
    }

    public static String getLocalHoliday(Temporal temporal) {
        return Holiday.getLocalHoliday(temporal, null);
    }

    public static String getLocalHoliday(Temporal temporal, Map<String, String> localHolidayMap) {
        Objects.requireNonNull(temporal, "temporal");
        StringBuilder localHoliday = new StringBuilder("");
        if (CollectionUtil.isEmpty(localHolidayMap)) {
            localHolidayMap = LocalHolidayEnum.convertToMap();
        }
        MonthDay monthDay = MonthDay.from(temporal);
        String monthDayStr = monthDay.format(DateTimeFormatterUtil.MMDD_FMT);
        for (Map.Entry<String, String> entry : localHolidayMap.entrySet()) {
            if (entry.getKey().equals(monthDayStr)) {
                if (localHoliday == null || localHoliday.length() == 0) {
                    localHoliday = new StringBuilder(entry.getValue());
                } else {
                    localHoliday.append(" " + entry.getValue());
                }
            }
            if (!entry.getKey().contains("W")) continue;
            String[] arr = entry.getKey().split("-");
            int month = Integer.parseInt(arr[0]);
            int weekIndex = Integer.parseInt(arr[2]);
            int weekValue = Integer.parseInt(arr[3]);
            DayOfWeek dow = DayOfWeek.of(weekValue);
            Temporal tempTem = temporal.with(ChronoField.MONTH_OF_YEAR, month);
            Temporal targetTem = tempTem.with(TemporalAdjusters.dayOfWeekInMonth(weekIndex, dow));
            MonthDay targetMonthDay = MonthDay.from(targetTem);
            String targetMonthDayStr = targetMonthDay.format(DateTimeFormatterUtil.MMDD_FMT);
            if (!monthDayStr.equals(targetMonthDayStr)) continue;
            if (localHoliday == null || localHoliday.length() == 0) {
                localHoliday = new StringBuilder(entry.getValue());
                continue;
            }
            localHoliday.append(" " + entry.getValue());
        }
        return localHoliday.toString();
    }

    public static String getChineseHoliday(Date date) {
        return Holiday.getChineseHoliday(date, null);
    }

    public static String getChineseHoliday(Date date, Map<String, String> chineseHolidayMap) {
        Objects.requireNonNull(date, "date");
        return Holiday.getChineseHoliday(DateTimeConverterUtil.toLocalDateTime(date), chineseHolidayMap);
    }

    public static String getChineseHoliday(Temporal temporal) {
        return Holiday.getChineseHoliday(temporal, null);
    }

    public static String getChineseHoliday(Temporal temporal, Map<String, String> chineseHolidayMap) {
        LunarDate lunarDate;
        Objects.requireNonNull(temporal, "temporal");
        StringBuilder chineseHoliday = new StringBuilder("");
        if (CollectionUtil.isEmpty(chineseHolidayMap)) {
            chineseHolidayMap = ChineseHolidayEnum.convertToMap();
        }
        if (StringUtil.isNotEmpty((lunarDate = LunarDate.from(temporal)).getLeapMonthCn())) {
            return chineseHoliday.toString();
        }
        String monthDayStr = lunarDate.formatShort();
        for (Map.Entry<String, String> entry : chineseHolidayMap.entrySet()) {
            LocalDate tempLocalDate;
            LocalDate targetLocalDate;
            LunarDate targetLunarDate;
            String targetMonthDayStr;
            if (entry.getKey().equals(monthDayStr)) {
                if (chineseHoliday == null || chineseHoliday.length() == 0) {
                    chineseHoliday = new StringBuilder(entry.getValue());
                } else {
                    chineseHoliday.append(" " + entry.getValue());
                }
            }
            if (!entry.getKey().equals("CHUXI") || !"0101".equals(targetMonthDayStr = (targetLunarDate = LunarDate.from(targetLocalDate = (tempLocalDate = lunarDate.getLocalDate()).plus(1L, ChronoUnit.DAYS))).formatShort())) continue;
            if (chineseHoliday == null || chineseHoliday.length() == 0) {
                chineseHoliday = new StringBuilder(entry.getValue());
                continue;
            }
            chineseHoliday.append(" " + entry.getValue());
        }
        return chineseHoliday.toString();
    }

    public static String getSolarTerm(Date date) {
        Objects.requireNonNull(date, "date");
        LunarDate lunarDate = LunarDate.from(date);
        return lunarDate.getSolarTerm();
    }

    public static String getSolarTerm(Temporal temporal) {
        Objects.requireNonNull(temporal, "temporal");
        LunarDate lunarDate = LunarDate.from(temporal);
        return lunarDate.getSolarTerm();
    }
}

