/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.interceptor.pagination;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserGlobal;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectModel;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.github.yulichang.interceptor.pagination.ParseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;

public class DialectWrapper {
    private final IDialect dialect;
    private final List<ParameterMapping> fullMappings = new ArrayList<ParameterMapping>();
    private final List<ParameterMapping> pageMappings = new ArrayList<ParameterMapping>();
    private String finallySql;

    public DialectWrapper(IDialect dialect) {
        this.dialect = dialect;
    }

    public void buildPaginationSql(String originalSql, List<ParameterMapping> mappings, long offset, long limit, Consumer<DialectModel> consumers, MappedStatement ms, Object parameter) {
        try {
            String formatSql;
            Select select = (Select)JsqlParserGlobal.parse((String)originalSql);
            if (select instanceof SetOperationList) {
                throw ExceptionUtils.mpe((String)"\u4e0d\u652f\u6301 union \u5bf9\u591a\u5206\u9875", (Object[])new Object[0]);
            }
            String sourceSql = select.toString();
            int count = ParseHelper.countChar(sourceSql);
            if (count == mappings.size()) {
                formatSql = ParseHelper.decode(sourceSql);
            } else {
                SqlSource sqlSource = ms.getSqlSource();
                if (sqlSource instanceof DynamicSqlSource) {
                    formatSql = ParseHelper.getOriginalSql(parameter, (DynamicSqlSource)sqlSource);
                } else {
                    throw ExceptionUtils.mpe((String)("unknown type: " + sqlSource.getClass().getName()), (Object[])new Object[0]);
                }
            }
            PlainSelect pageSql = (PlainSelect)JsqlParserGlobal.parse((String)formatSql);
            List joins = pageSql.getJoins();
            if (CollectionUtils.isNotEmpty((Collection)joins)) {
                pageSql.setJoins(null);
            }
            pageSql.setSelectItems(Collections.singletonList(new SelectItem((Expression)new Column().withColumnName("*"))));
            String repSql = pageSql.toString();
            HashMap<Integer, ParameterMapping> sortMap = new HashMap<Integer, ParameterMapping>();
            repSql = ParseHelper.encode(mappings, count, repSql, sortMap);
            this.pageMappings.addAll(sortMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList()));
            DialectModel dialectModel = this.dialect.buildPaginationSql(repSql, offset, limit);
            consumers.accept(dialectModel);
            String formatDialectSql = ParseHelper.decode(dialectModel.getDialectSql(), i -> "s" + i);
            PlainSelect fullSql = (PlainSelect)JsqlParserGlobal.parse((String)formatSql);
            PlainSelect finalPlainSelect = new PlainSelect();
            finalPlainSelect.setSelectItems(fullSql.getSelectItems());
            finalPlainSelect.setDistinct(fullSql.getDistinct());
            finalPlainSelect.setFromItem((FromItem)new Table().withName("(" + formatDialectSql + ")").withAlias(new Alias(fullSql.getFromItem().getAlias().getName(), false)));
            finalPlainSelect.setJoins(fullSql.getJoins());
            String finalSql = finalPlainSelect.toString();
            HashMap<Integer, ParameterMapping> finalSortMap = new HashMap<Integer, ParameterMapping>();
            for (int i2 = 0; i2 < count; ++i2) {
                String repStr = ParseHelper.format.apply("s" + i2);
                int i1 = finalSql.indexOf(repStr);
                if (i1 == -1) continue;
                finalSql = finalSql.replace(repStr, "?");
                finalSortMap.put(i1, this.pageMappings.get(i2));
            }
            finalSql = ParseHelper.encode(mappings, count, finalSql, finalSortMap);
            this.fullMappings.addAll(finalSortMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList()));
            this.finallySql = finalSql;
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((String)("not support this sql, please use xml. error sql: " + originalSql), (Object[])new Object[0]);
        }
    }

    @Generated
    public List<ParameterMapping> getFullMappings() {
        return this.fullMappings;
    }

    @Generated
    public List<ParameterMapping> getPageMappings() {
        return this.pageMappings;
    }

    @Generated
    public String getFinallySql() {
        return this.finallySql;
    }
}

