/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.github.yulichang.adapter.AdapterHelper;
import com.github.yulichang.toolkit.LogicInfoUtils;
import com.github.yulichang.toolkit.StrUtils;
import com.github.yulichang.toolkit.TableHelper;
import com.github.yulichang.toolkit.TableList;
import com.github.yulichang.wrapper.JoinAbstractLambdaWrapper;
import com.github.yulichang.wrapper.interfaces.DeleteChain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class DeleteJoinWrapper<T>
extends JoinAbstractLambdaWrapper<T, DeleteJoinWrapper<T>>
implements DeleteChain<T> {
    private final SharedString deleteSql = new SharedString();
    private List<Class<?>> deleteTableList;
    private List<String> deleteTableName;
    private boolean deleteAll = false;

    private DeleteJoinWrapper() {
    }

    public DeleteJoinWrapper(Class<T> clazz) {
        super(clazz);
    }

    public DeleteJoinWrapper(Class<T> clazz, String alias) {
        super(clazz, alias);
    }

    @Override
    public String getDeleteSql() {
        if (StrUtils.isNotBlank(this.deleteSql.getStringValue())) {
            return this.deleteSql.getStringValue();
        }
        String delete = null;
        if (this.deleteAll) {
            this.check();
            List tables = this.tableList.getAll().stream().map(i -> i.isHasAlias() ? i.getAlias() : i.getAlias() + i.getIndex()).collect(Collectors.toList());
            tables.add(0, this.alias);
            delete = String.join((CharSequence)",", tables);
        } else if (CollectionUtils.isNotEmpty(this.deleteTableList)) {
            delete = this.deleteTableList.stream().map(c -> this.tableList.getPrefixByClassAssert((Class<?>)c)).collect(Collectors.joining(","));
        }
        if (CollectionUtils.isNotEmpty(this.deleteTableName)) {
            delete = delete + "," + String.join((CharSequence)",", this.deleteTableName);
        }
        if (StrUtils.isBlank(delete)) {
            delete = this.alias;
        }
        this.deleteSql.setStringValue(delete);
        return delete;
    }

    @Override
    public String getDeleteLogicSql() {
        if (StrUtils.isNotBlank(this.deleteSql.getStringValue())) {
            return this.deleteSql.getStringValue();
        }
        String delete = null;
        if (this.deleteAll) {
            this.check();
            delete = this.tableList.getAll().stream().map(i -> LogicInfoUtils.getLogicInfoInvert(i.getIndex(), i.getClazz(), i.isHasAlias(), i.getAlias())).collect(Collectors.joining(","));
        } else if (CollectionUtils.isNotEmpty(this.deleteTableList)) {
            delete = this.deleteTableList.stream().map(c -> this.tableList.getByClassFirst((Class<?>)c)).map(i -> LogicInfoUtils.getLogicInfoInvert(i.getIndex(), i.getClazz(), i.isHasAlias(), i.getAlias())).collect(Collectors.joining(","));
        }
        if (CollectionUtils.isNotEmpty(this.deleteTableName)) {
            delete = delete + "," + String.join((CharSequence)",", this.deleteTableName);
        }
        delete = StrUtils.isNotBlank(delete) ? "," + delete : "";
        this.deleteSql.setStringValue(delete);
        return delete;
    }

    public DeleteJoinWrapper<T> deleteAll() {
        this.deleteAll = true;
        return (DeleteJoinWrapper)this.typedThis;
    }

    public DeleteJoinWrapper<T> delete(String ... tables) {
        if (CollectionUtils.isEmpty(this.deleteTableName)) {
            this.deleteTableName = new ArrayList<String>();
            this.deleteTableName.addAll(Arrays.asList(tables));
        }
        return (DeleteJoinWrapper)this.typedThis;
    }

    public DeleteJoinWrapper<T> delete(Class<?> ... deleteClass) {
        Class entityClass = this.getEntityClass();
        Assert.notNull(entityClass, (String)"\u7f3a\u5c11\u4e3b\u8868\u7c7b\u578b, \u8bf7\u4f7f\u7528 new MPJLambdaWrapper<>(\u4e3b\u8868.class) \u6216 JoinWrappers.lambda(\u4e3b\u8868.class) \u6784\u9020\u65b9\u6cd5", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(this.deleteTableList)) {
            this.deleteTableList = new ArrayList();
        }
        this.check(Arrays.asList(deleteClass));
        this.deleteTableList.addAll(Arrays.asList(deleteClass));
        return (DeleteJoinWrapper)this.typedThis;
    }

    private void check(List<Class<?>> classList) {
        Class entityClass = this.getEntityClass();
        TableInfo tableInfo = TableHelper.getAssert(entityClass);
        boolean mainLogic = AdapterHelper.getAdapter().mpjHasLogic(tableInfo);
        boolean check = classList.stream().allMatch(t -> {
            TableInfo ti = TableHelper.getAssert(t);
            return mainLogic == AdapterHelper.getAdapter().mpjHasLogic(ti);
        });
        if (!check) {
            throw ExceptionUtils.mpe((String)"\u8fde\u8868\u5220\u9664\u53ea\u9002\u7528\u4e8e\u5168\u90e8\u8868(\u4e3b\u8868\u548c\u526f\u8868)\u90fd\u662f\u7269\u7406\u5220\u9664\u6216\u5168\u90e8\u90fd\u662f\u903b\u8f91\u5220\u9664, \u4e0d\u652f\u6301\u540c\u65f6\u5b58\u5728\u7269\u7406\u5220\u9664\u548c\u903b\u8f91\u5220\u9664 [\u7269\u7406\u5220\u9664->(%s)] [\u903b\u8f91\u5220\u9664->(%s)]", (Object[])new Object[]{classList.stream().filter(t -> !AdapterHelper.getAdapter().mpjHasLogic(TableHelper.getAssert(t))).map(Class::getSimpleName).collect(Collectors.joining(",")), classList.stream().filter(t -> AdapterHelper.getAdapter().mpjHasLogic(TableHelper.getAssert(t))).map(Class::getSimpleName).collect(Collectors.joining(","))});
        }
    }

    private void check() {
        if (CollectionUtils.isNotEmpty(this.tableList.getAll())) {
            Class entityClass = this.getEntityClass();
            Assert.notNull(entityClass, (String)"\u7f3a\u5c11\u4e3b\u8868\u7c7b\u578b, \u8bf7\u4f7f\u7528 new MPJLambdaWrapper<>(\u4e3b\u8868.class) \u6216 JoinWrappers.lambda(\u4e3b\u8868.class) \u6784\u9020\u65b9\u6cd5", (Object[])new Object[0]);
            ArrayList list = this.tableList.getAll().stream().map(TableList.Node::getClazz).collect(Collectors.toCollection(ArrayList::new));
            list.add(entityClass);
            this.check(list);
        }
    }

    @Override
    protected DeleteJoinWrapper<T> instance() {
        return this.instance(this.index, (String)null, (Class)null, (String)null);
    }

    @Override
    protected DeleteJoinWrapper<T> instanceEmpty() {
        return new DeleteJoinWrapper<T>();
    }

    @Override
    protected DeleteJoinWrapper<T> instance(Integer index, String keyWord, Class<?> joinClass, String tableName) {
        return new DeleteJoinWrapper(this.getEntity(), this.getEntityClass(), this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString(), this.tableList, index, keyWord, joinClass, tableName);
    }

    protected DeleteJoinWrapper(T entity, Class<T> entityClass, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst, TableList tableList, Integer index, String keyWord, Class<?> joinClass, String tableName) {
        super.setEntity(entity);
        super.setEntityClass(entityClass);
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
        this.tableList = tableList;
        this.index = index;
        this.keyWord = keyWord;
        this.joinClass = joinClass;
        this.tableName = tableName;
    }

    @Override
    public void clear() {
        super.clear();
        if (CollectionUtils.isNotEmpty(this.deleteTableList)) {
            this.deleteTableList.clear();
        }
        if (CollectionUtils.isNotEmpty(this.deleteTableName)) {
            this.deleteTableName.clear();
        }
        this.deleteSql.toNull();
        this.deleteAll = false;
    }
}

