/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.security.aspect;

import cn.hutool.core.util.StrUtil;
import com.github.zuihou.exception.BizException;
import com.github.zuihou.exception.code.BaseExceptionCode;
import com.github.zuihou.exception.code.ExceptionCode;
import com.github.zuihou.security.annotation.PreAuth;
import com.github.zuihou.security.aspect.VerifyAuthFunction;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class UriSecurityPreAuthAspect
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(UriSecurityPreAuthAspect.class);
    private static final ExpressionParser SPEL_PARSER = new SpelExpressionParser();
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final VerifyAuthFunction verifyAuthFunction;
    private ApplicationContext ac;

    public UriSecurityPreAuthAspect(VerifyAuthFunction verifyAuthFunction) {
        this.verifyAuthFunction = verifyAuthFunction;
    }

    @Around(value="execution(public * com.github.zuihou.base.controller.*.*(..)) || @annotation(com.github.zuihou.security.annotation.PreAuth) || @within(com.github.zuihou.security.annotation.PreAuth)")
    public Object preAuth(ProceedingJoinPoint point) throws Throwable {
        if (this.handleAuth(point)) {
            return point.proceed();
        }
        throw BizException.wrap((BaseExceptionCode)ExceptionCode.UNAUTHORIZED);
    }

    private boolean handleAuth(ProceedingJoinPoint point) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        PreAuth preAuth = null;
        if (point.getSignature() instanceof MethodSignature && (method = ((MethodSignature)point.getSignature()).getMethod()) != null) {
            preAuth = method.getAnnotation(PreAuth.class);
        }
        PreAuth targetClass = point.getTarget().getClass().getAnnotation(PreAuth.class);
        if (preAuth == null && targetClass == null) {
            log.debug("\u6267\u884c\u65b9\u6cd5[{}]\u65e0\u9700\u6821\u9a8c\u6743\u9650", (Object)method.getName());
            return true;
        }
        if (preAuth != null && !preAuth.enabled()) {
            log.debug("\u6267\u884c\u65b9\u6cd5[{}]\u65e0\u9700\u6821\u9a8c\u6743\u9650", (Object)method.getName());
            return true;
        }
        if (targetClass != null && !targetClass.enabled()) {
            log.debug("\u6267\u884c\u65b9\u6cd5[{}]\u65e0\u9700\u6821\u9a8c\u6743\u9650", (Object)method.getName());
            return true;
        }
        String condition = null;
        condition = preAuth == null ? targetClass.value() : preAuth.value();
        if (StrUtil.isBlank((CharSequence)condition)) {
            return true;
        }
        if (condition.contains("{}")) {
            if (targetClass != null && StrUtil.isNotBlank((CharSequence)targetClass.replace())) {
                condition = StrUtil.format((CharSequence)condition, (Object[])new Object[]{targetClass.replace()});
            } else {
                return true;
            }
        }
        Expression expression = SPEL_PARSER.parseExpression(condition);
        Object[] args = point.getArgs();
        StandardEvaluationContext context = new StandardEvaluationContext((Object)this.verifyAuthFunction);
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.ac));
        for (int i = 0; i < args.length; ++i) {
            SynthesizingMethodParameter mp = new SynthesizingMethodParameter(method, i);
            mp.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
            context.setVariable(mp.getParameterName(), args[i]);
        }
        if (((Boolean)expression.getValue((EvaluationContext)context, Boolean.class)).booleanValue()) {
            return true;
        }
        throw BizException.wrap((BaseExceptionCode)ExceptionCode.UNAUTHORIZED.build("\u6267\u884c\u65b9\u6cd5[%s]\u9700\u8981[%s]\u6743\u9650", new Object[]{method.getName(), condition}));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ac = applicationContext;
    }
}

