/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.security.interceptor;

import cn.hutool.core.util.URLUtil;
import com.github.zuihou.context.BaseContextHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ContextHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(ContextHandlerInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return super.preHandle(request, response, handler);
        }
        if (!BaseContextHandler.getBoot().booleanValue()) {
            BaseContextHandler.setUserId((String)this.getHeader(request, "userid"));
            BaseContextHandler.setAccount((String)this.getHeader(request, "account"));
            BaseContextHandler.setName((String)this.getHeader(request, "name"));
        }
        BaseContextHandler.setGrayVersion((String)this.getHeader(request, "grayversion"));
        return super.preHandle(request, response, handler);
    }

    private String getHeader(HttpServletRequest request, String name) {
        String value = request.getHeader(name);
        if (StringUtils.isEmpty((Object)value)) {
            return "";
        }
        return URLUtil.decode((String)value);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        BaseContextHandler.remove();
        super.afterCompletion(request, response, handler, ex);
    }
}

