/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.security.model;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SysRole {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String code;
    private String describe;
    private Boolean isEnable;
    private Boolean isReadonly;

    public static List<String> getRoleCode(List<SysRole> list) {
        if (ArrayUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().map(SysRole::getCode).collect(Collectors.toList());
    }

    public static boolean contains(List<SysRole> list, String code) {
        if (ArrayUtil.isEmpty(list) || StrUtil.isEmpty((CharSequence)code)) {
            return false;
        }
        return list.stream().anyMatch(item -> code.equals(item.getCode()));
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescribe() {
        return this.describe;
    }

    public Boolean getIsEnable() {
        return this.isEnable;
    }

    public Boolean getIsReadonly() {
        return this.isReadonly;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public void setIsEnable(Boolean isEnable) {
        this.isEnable = isEnable;
    }

    public void setIsReadonly(Boolean isReadonly) {
        this.isReadonly = isReadonly;
    }

    public SysRole() {
    }

    public SysRole(Long id, String name, String code, String describe, Boolean isEnable, Boolean isReadonly) {
        this.id = id;
        this.name = name;
        this.code = code;
        this.describe = describe;
        this.isEnable = isEnable;
        this.isReadonly = isReadonly;
    }

    public String toString() {
        return "SysRole(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", code=" + this.getCode() + ", describe=" + this.getDescribe() + ", isEnable=" + this.getIsEnable() + ", isReadonly=" + this.getIsReadonly() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SysRole)) {
            return false;
        }
        SysRole other = (SysRole)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$describe = this.getDescribe();
        String other$describe = other.getDescribe();
        if (this$describe == null ? other$describe != null : !this$describe.equals(other$describe)) {
            return false;
        }
        Boolean this$isEnable = this.getIsEnable();
        Boolean other$isEnable = other.getIsEnable();
        if (this$isEnable == null ? other$isEnable != null : !((Object)this$isEnable).equals(other$isEnable)) {
            return false;
        }
        Boolean this$isReadonly = this.getIsReadonly();
        Boolean other$isReadonly = other.getIsReadonly();
        return !(this$isReadonly == null ? other$isReadonly != null : !((Object)this$isReadonly).equals(other$isReadonly));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SysRole;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $describe = this.getDescribe();
        result = result * 59 + ($describe == null ? 43 : $describe.hashCode());
        Boolean $isEnable = this.getIsEnable();
        result = result * 59 + ($isEnable == null ? 43 : ((Object)$isEnable).hashCode());
        Boolean $isReadonly = this.getIsReadonly();
        result = result * 59 + ($isReadonly == null ? 43 : ((Object)$isReadonly).hashCode());
        return result;
    }
}

