/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel;

import com.gs.collections.api.ParallelIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.multimap.bag.UnsortedBagMultimap;
import com.gs.collections.api.set.ParallelUnsortedSetIterable;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.lazy.parallel.AbstractParallelIterable;
import com.gs.collections.impl.lazy.parallel.Batch;
import com.gs.collections.impl.lazy.parallel.ParallelDistinctIterable;
import com.gs.collections.impl.lazy.parallel.ParallelSelectIterable;
import com.gs.collections.impl.lazy.parallel.set.ParallelCollectIterable;
import com.gs.collections.impl.multimap.bag.SynchronizedPutHashBagMultimap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractParallelIterableImpl<T, B extends Batch<T>>
extends AbstractParallelIterable<T, B> {
    @Override
    protected boolean isOrdered() {
        return false;
    }

    public ParallelUnsortedSetIterable<T> asUnique() {
        return new ParallelDistinctIterable(this);
    }

    public ParallelIterable<T> select(Predicate<? super T> predicate) {
        return new ParallelSelectIterable<T>(this, predicate);
    }

    public <P> ParallelIterable<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public <S> ParallelIterable<S> selectInstancesOf(Class<S> clazz) {
        return this.select(Predicates.instanceOf(clazz));
    }

    public ParallelIterable<T> reject(Predicate<? super T> predicate) {
        return this.select(Predicates.not(predicate));
    }

    public <P> ParallelIterable<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public <V> ParallelIterable<V> collect(Function<? super T, ? extends V> function) {
        return new ParallelCollectIterable<T, V>(this, function);
    }

    public <P, V> ParallelIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect(Functions.bind(function, parameter));
    }

    public <V> ParallelIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.select(predicate).collect(function);
    }

    public <V> ParallelIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        throw new UnsupportedOperationException();
    }

    public <V> UnsortedBagMultimap<V, T> groupBy(final Function<? super T, ? extends V> function) {
        final SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEach(new Procedure<T>(){

            public void value(T each) {
                Object key = function.valueOf(each);
                result.put(key, each);
            }
        });
        return result;
    }

    public <V> UnsortedBagMultimap<V, T> groupByEach(final Function<? super T, ? extends Iterable<V>> function) {
        final SynchronizedPutHashBagMultimap result = SynchronizedPutHashBagMultimap.newMultimap();
        this.forEach(new Procedure<T>(){

            public void value(T each) {
                Iterable keys = (Iterable)function.valueOf(each);
                for (Object key : keys) {
                    result.put(key, each);
                }
            }
        });
        return result;
    }

    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".groupByUniqueKey() not implemented yet");
    }
}

