/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.DoubleToShortFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.DoubleShortMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleShortMap;
import com.gs.collections.api.map.primitive.MutableDoubleShortMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.api.tuple.primitive.DoubleShortPair;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedShortCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.DoubleSets;
import com.gs.collections.impl.factory.primitive.DoubleShortMaps;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedDoubleShortMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableDoubleShortMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedDoubleSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleShortHashMap
implements MutableDoubleShortMap,
Externalizable {
    static final short EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private double[] keys;
    private short[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public DoubleShortHashMap() {
        this.allocateTable(16);
    }

    public DoubleShortHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public DoubleShortHashMap(DoubleShortMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static DoubleShortHashMap newWithKeysValues(double key1, short value1) {
        return new DoubleShortHashMap(1).withKeyValue(key1, value1);
    }

    public static DoubleShortHashMap newWithKeysValues(double key1, short value1, double key2, short value2) {
        return new DoubleShortHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static DoubleShortHashMap newWithKeysValues(double key1, short value1, double key2, short value2, double key3, short value3) {
        return new DoubleShortHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static DoubleShortHashMap newWithKeysValues(double key1, short value1, double key2, short value2, double key3, short value3, double key4, short value4) {
        return new DoubleShortHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleShortMap)) {
            return false;
        }
        DoubleShortMap other = (DoubleShortMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0) || other.containsKey(1.0)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0) || this.sentinelValues.zeroValue != other.getOrThrow(0.0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0) || this.sentinelValues.oneValue != other.getOrThrow(1.0))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleShortHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32) ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32) ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(Double.doubleToLongBits(this.keys[i]) ^ Double.doubleToLongBits(this.keys[i]) >>> 32) ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf(0.0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf(1.0)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleShortHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                double key = this.keys[i];
                if (!DoubleShortHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    public short[] toArray() {
        short[] array = new short[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(short value) {
        return this.containsValue(value);
    }

    public boolean containsAll(short ... source) {
        for (short each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        return source.allSatisfy(new ShortPredicate(){

            public boolean accept(short value) {
                return DoubleShortHashMap.this.contains(value);
            }
        });
    }

    public void forEach(ShortProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableShortCollection select(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableShortCollection reject(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public short detectIfNone(ShortPredicate predicate, short value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(ShortPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectShortToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableShortList toList() {
        return ShortArrayList.newList((ShortIterable)this);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSet((ShortIterable)this);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBag((ShortIterable)this);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0.0);
        Arrays.fill(this.values, (short)0);
    }

    public void put(double key, short value) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addEmptyKeyValue(value);
            return;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addRemovedKeyValue(value);
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(DoubleShortMap map) {
        map.forEachKeyValue(new DoubleShortProcedure(){

            public void value(double key, short value) {
                DoubleShortHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(double key) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(double key) {
        this.removeKey(key);
    }

    public short removeKeyIfAbsent(double key, short value) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            short oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            short oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0;
            short oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public short getIfAbsentPut(double key, short value) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPut(double key, ShortFunction0 function) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        short value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> short getIfAbsentPutWith(double key, ShortFunction<? super P> function, P parameter) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.shortValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.shortValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        short value = function.shortValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPutWithKey(double key, DoubleToShortFunction function) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        short value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short addToValue(double key, short toBeAdded) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (short)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (short)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            int n = index;
            this.values[n] = (short)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(double key, short value, int index) {
        if (Double.compare(this.keys[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void addEmptyKeyValue(short value) {
        this.sentinelValues.containsZeroKey = true;
        this.sentinelValues.zeroValue = value;
    }

    private void removeEmptyKey() {
        if (this.sentinelValues.containsOneKey) {
            this.sentinelValues.containsZeroKey = false;
            this.sentinelValues.zeroValue = (short)0;
        } else {
            this.sentinelValues = null;
        }
    }

    private void addRemovedKeyValue(short value) {
        this.sentinelValues.containsOneKey = true;
        this.sentinelValues.oneValue = value;
    }

    private void removeRemovedKey() {
        if (this.sentinelValues.containsZeroKey) {
            this.sentinelValues.containsOneKey = false;
            this.sentinelValues.oneValue = (short)0;
        } else {
            this.sentinelValues = null;
        }
    }

    public short updateValue(double key, short initialValueIfAbsent, ShortToShortFunction function) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        short value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public DoubleShortHashMap withKeyValue(double key1, short value1) {
        this.put(key1, value1);
        return this;
    }

    public DoubleShortHashMap withKeysValues(double key1, short value1, double key2, short value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public DoubleShortHashMap withKeysValues(double key1, short value1, double key2, short value2, double key3, short value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public DoubleShortHashMap withKeysValues(double key1, short value1, double key2, short value2, double key3, short value3, double key4, short value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public DoubleShortHashMap withoutKey(double key) {
        this.removeKey(key);
        return this;
    }

    public DoubleShortHashMap withoutAllKeys(DoubleIterable keys) {
        keys.forEach(new DoubleProcedure(){

            public void value(double key) {
                DoubleShortHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableDoubleShortMap asUnmodifiable() {
        return new UnmodifiableDoubleShortMap(this);
    }

    public MutableDoubleShortMap asSynchronized() {
        return new SynchronizedDoubleShortMap(this);
    }

    public ImmutableDoubleShortMap toImmutable() {
        return DoubleShortMaps.immutable.ofAll((DoubleShortMap)this);
    }

    public short get(double key) {
        return this.getIfAbsent(key, (short)0);
    }

    public short getIfAbsent(double key, short ifAbsent) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public short getOrThrow(double key) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (DoubleShortHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(double key) {
        if (DoubleShortHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (DoubleShortHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Double.compare(this.keys[this.probe(key)], key) == 0;
    }

    public boolean containsValue(short value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(ShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0);
            }
        }
        for (double key : this.keys) {
            if (!DoubleShortHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(DoubleShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyDoubleIterable keysView() {
        return new KeysView();
    }

    public RichIterable<DoubleShortPair> keyValuesView() {
        return new KeyValuesView();
    }

    public DoubleShortHashMap select(DoubleShortPredicate predicate) {
        DoubleShortHashMap result = new DoubleShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public DoubleShortHashMap reject(DoubleShortPredicate predicate) {
        DoubleShortHashMap result = new DoubleShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public short max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ShortIterator iterator = this.shortIterator();
        short max = iterator.next();
        while (iterator.hasNext()) {
            short value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public short maxIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public short min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ShortIterator iterator = this.shortIterator();
        short min = iterator.next();
        while (iterator.hasNext()) {
            short value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public short minIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newList((ShortIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeDouble(0.0);
                out.writeShort(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeDouble(1.0);
                out.writeShort(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeDouble(this.keys[i]);
            out.writeShort(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readDouble(), in.readShort());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        double[] old = this.keys;
        short[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!DoubleShortHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(double element) {
        int index = this.spread(element);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, element) == 0 || Double.compare(keyAtIndex, 0.0) == 0) {
            return index;
        }
        int removedIndex = Double.compare(keyAtIndex, 1.0) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (Double.compare(this.keys[nextIndex &= this.keys.length - 1], element) == 0) {
                return nextIndex;
            }
            if (Double.compare(this.keys[nextIndex], 1.0) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Double.compare(this.keys[nextIndex], 0.0) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(double element) {
        long code = Double.doubleToLongBits(element);
        code = (code ^ 0xFFFFFFFFFFFFFFFFL) + (code << 18);
        code = (code << 18) - code - 1L;
        code ^= code >>> 31;
        code *= 21L;
        code += (code << 2) + (code << 4);
        code ^= code >>> 11;
        code += code << 6;
        code ^= code >>> 22;
        return (int)code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new double[sizeToAllocate];
        this.values = new short[sizeToAllocate];
    }

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !DoubleShortHashMap.isEmptyKey(key) && !DoubleShortHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableDoubleSet keySet() {
        return new KeySet();
    }

    public MutableShortCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ double[] access$802(DoubleShortHashMap x0, double[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ short[] access$1002(DoubleShortHashMap x0, short[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<DoubleShortPair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super DoubleShortPair> procedure) {
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0, DoubleShortHashMap.this.sentinelValues.zeroValue));
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0, DoubleShortHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(DoubleShortHashMap.this.keys[i], DoubleShortHashMap.this.values[i]));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super DoubleShortPair> objectIntProcedure) {
            int index = 0;
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0.0, DoubleShortHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1.0, DoubleShortHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(DoubleShortHashMap.this.keys[i], DoubleShortHashMap.this.values[i]), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super DoubleShortPair, ? super P> procedure, P parameter) {
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0, DoubleShortHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0, DoubleShortHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(DoubleShortHashMap.this.keys[i], DoubleShortHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<DoubleShortPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<DoubleShortPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public DoubleShortPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (DoubleShortHashMap.this.containsKey(0.0)) {
                        return PrimitiveTuples.pair(0.0, DoubleShortHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (DoubleShortHashMap.this.containsKey(1.0)) {
                        return PrimitiveTuples.pair(1.0, DoubleShortHashMap.this.sentinelValues.oneValue);
                    }
                }
                double[] keys = DoubleShortHashMap.this.keys;
                while (!DoubleShortHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                DoubleShortPair result = PrimitiveTuples.pair(keys[this.position], DoubleShortHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != DoubleShortHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableShortCollection {
        private ValuesCollection() {
        }

        public void clear() {
            DoubleShortHashMap.this.clear();
        }

        public MutableShortCollection select(ShortPredicate predicate) {
            return DoubleShortHashMap.this.select(predicate);
        }

        public MutableShortCollection reject(ShortPredicate predicate) {
            return DoubleShortHashMap.this.reject(predicate);
        }

        public short detectIfNone(ShortPredicate predicate, short ifNone) {
            return DoubleShortHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
            return DoubleShortHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
            return DoubleShortHashMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return DoubleShortHashMap.this.sum();
        }

        public short max() {
            return DoubleShortHashMap.this.max();
        }

        public short maxIfEmpty(short defaultValue) {
            return DoubleShortHashMap.this.maxIfEmpty(defaultValue);
        }

        public short min() {
            return DoubleShortHashMap.this.min();
        }

        public short minIfEmpty(short defaultValue) {
            return DoubleShortHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return DoubleShortHashMap.this.average();
        }

        public double median() {
            return DoubleShortHashMap.this.median();
        }

        public short[] toSortedArray() {
            return DoubleShortHashMap.this.toSortedArray();
        }

        public MutableShortList toSortedList() {
            return DoubleShortHashMap.this.toSortedList();
        }

        public MutableShortCollection with(short element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection without(short element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection withAll(ShortIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection withoutAll(ShortIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection asUnmodifiable() {
            return UnmodifiableShortCollection.of(this);
        }

        public MutableShortCollection asSynchronized() {
            return SynchronizedShortCollection.of(this);
        }

        public ImmutableShortCollection toImmutable() {
            return ShortLists.immutable.withAll((ShortIterable)this);
        }

        public boolean contains(short value) {
            return DoubleShortHashMap.this.containsValue(value);
        }

        public boolean containsAll(short ... source) {
            return DoubleShortHashMap.this.containsAll(source);
        }

        public boolean containsAll(ShortIterable source) {
            return DoubleShortHashMap.this.containsAll(source);
        }

        public MutableShortList toList() {
            return DoubleShortHashMap.this.toList();
        }

        public MutableShortSet toSet() {
            return DoubleShortHashMap.this.toSet();
        }

        public MutableShortBag toBag() {
            return DoubleShortHashMap.this.toBag();
        }

        public LazyShortIterable asLazy() {
            return new LazyShortIterableAdapter((ShortIterable)this);
        }

        public boolean isEmpty() {
            return DoubleShortHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleShortHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleShortHashMap.this.sentinelValues != null) {
                    if (DoubleShortHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(DoubleShortHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (DoubleShortHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(DoubleShortHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                    double key = DoubleShortHashMap.this.keys[i];
                    if (!DoubleShortHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(DoubleShortHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ShortIterator shortIterator() {
            return DoubleShortHashMap.this.shortIterator();
        }

        public void forEach(ShortProcedure procedure) {
            DoubleShortHashMap.this.forEach(procedure);
        }

        public int count(ShortPredicate predicate) {
            return DoubleShortHashMap.this.count(predicate);
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            return DoubleShortHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            return DoubleShortHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            return DoubleShortHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(short element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(short ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(ShortIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(short item) {
            int oldSize = DoubleShortHashMap.this.size();
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey && item == DoubleShortHashMap.this.sentinelValues.zeroValue) {
                    DoubleShortHashMap.this.removeKey(0.0);
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey && item == DoubleShortHashMap.this.sentinelValues.oneValue) {
                    DoubleShortHashMap.this.removeKey(1.0);
                }
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i]) || item != DoubleShortHashMap.this.values[i]) continue;
                DoubleShortHashMap.this.removeKey(DoubleShortHashMap.this.keys[i]);
            }
            return oldSize != DoubleShortHashMap.this.size();
        }

        public boolean removeAll(ShortIterable source) {
            int oldSize = DoubleShortHashMap.this.size();
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != DoubleShortHashMap.this.size();
        }

        public boolean removeAll(short ... source) {
            int oldSize = DoubleShortHashMap.this.size();
            for (short item : source) {
                this.remove(item);
            }
            return oldSize != DoubleShortHashMap.this.size();
        }

        public boolean retainAll(ShortIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            DoubleShortHashMap retained = DoubleShortHashMap.this.select(new DoubleShortPredicate((ShortSet)sourceSet){
                final /* synthetic */ ShortSet val$sourceSet;
                {
                    this.val$sourceSet = shortSet;
                }

                public boolean accept(double key, short value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                DoubleShortHashMap.access$802(DoubleShortHashMap.this, retained.keys);
                DoubleShortHashMap.access$1002(DoubleShortHashMap.this, retained.values);
                DoubleShortHashMap.this.sentinelValues = retained.sentinelValues;
                DoubleShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                DoubleShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(short ... source) {
            return this.retainAll((ShortIterable)ShortHashSet.newSetWith(source));
        }

        public int size() {
            return DoubleShortHashMap.this.size();
        }

        public short[] toArray() {
            return DoubleShortHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableDoubleSet {
        private KeySet() {
        }

        public DoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            DoubleShortHashMap.this.forEachKey(procedure);
        }

        public int count(DoublePredicate predicate) {
            int count = 0;
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    ++count;
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    ++count;
                }
            }
            for (double key : DoubleShortHashMap.this.keys) {
                if (!DoubleShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return true;
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return true;
                }
            }
            for (double key : DoubleShortHashMap.this.keys) {
                if (!DoubleShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleShortHashMap.this.keys) {
                if (!DoubleShortHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleShortHashMap.this.keys) {
                if (!DoubleShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(double element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(double key) {
            int oldSize = DoubleShortHashMap.this.size();
            DoubleShortHashMap.this.removeKey(key);
            return oldSize != DoubleShortHashMap.this.size();
        }

        public boolean removeAll(DoubleIterable source) {
            int oldSize = DoubleShortHashMap.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                DoubleShortHashMap.this.removeKey(iterator.next());
            }
            return oldSize != DoubleShortHashMap.this.size();
        }

        public boolean removeAll(double ... source) {
            int oldSize = DoubleShortHashMap.this.size();
            for (double item : source) {
                DoubleShortHashMap.this.removeKey(item);
            }
            return oldSize != DoubleShortHashMap.this.size();
        }

        public boolean retainAll(DoubleIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            DoubleShortHashMap retained = DoubleShortHashMap.this.select(new DoubleShortPredicate((DoubleSet)sourceSet){
                final /* synthetic */ DoubleSet val$sourceSet;
                {
                    this.val$sourceSet = doubleSet;
                }

                public boolean accept(double key, short value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                DoubleShortHashMap.access$802(DoubleShortHashMap.this, retained.keys);
                DoubleShortHashMap.access$1002(DoubleShortHashMap.this, retained.values);
                DoubleShortHashMap.this.sentinelValues = retained.sentinelValues;
                DoubleShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                DoubleShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(double ... source) {
            return this.retainAll((DoubleIterable)DoubleHashSet.newSetWith(source));
        }

        public void clear() {
            DoubleShortHashMap.this.clear();
        }

        public MutableDoubleSet select(DoublePredicate predicate) {
            DoubleHashSet result = new DoubleHashSet();
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    result.add(0.0);
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    result.add(1.0);
                }
            }
            for (double key : DoubleShortHashMap.this.keys) {
                if (!DoubleShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableDoubleSet reject(DoublePredicate predicate) {
            DoubleHashSet result = new DoubleHashSet();
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    result.add(0.0);
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    result.add(1.0);
                }
            }
            for (double key : DoubleShortHashMap.this.keys) {
                if (!DoubleShortHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableDoubleSet with(double element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleSet without(double element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleSet withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableDoubleSet withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return 0.0;
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return 1.0;
                }
            }
            for (double key : DoubleShortHashMap.this.keys) {
                if (!DoubleShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0.0));
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1.0));
                }
            }
            for (double key : DoubleShortHashMap.this.keys) {
                if (!DoubleShortHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableDoubleSet asUnmodifiable() {
            return UnmodifiableDoubleSet.of(this);
        }

        public MutableDoubleSet asSynchronized() {
            return SynchronizedDoubleSet.of(this);
        }

        public double sum() {
            double sum = 0.0;
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0.0;
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey) {
                    sum += 1.0;
                }
            }
            for (double key : DoubleShortHashMap.this.keys) {
                if (!DoubleShortHashMap.isNonSentinel(key)) continue;
                sum += key;
            }
            return sum;
        }

        public double max() {
            if (DoubleShortHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double max = 0.0;
            boolean isMaxSet = false;
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0.0;
                    isMaxSet = true;
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || Double.compare(max, 1.0) < 0)) {
                    max = 1.0;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i]) || isMaxSet && Double.compare(max, DoubleShortHashMap.this.keys[i]) >= 0) continue;
                max = DoubleShortHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public double maxIfEmpty(double defaultValue) {
            if (DoubleShortHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double min() {
            if (DoubleShortHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double min = 0.0;
            boolean isMinSet = false;
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0.0;
                    isMinSet = true;
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey && (!isMinSet || Double.compare(1.0, min) < 0)) {
                    min = 1.0;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i]) || isMinSet && Double.compare(DoubleShortHashMap.this.keys[i], min) >= 0) continue;
                min = DoubleShortHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public double minIfEmpty(double defaultValue) {
            if (DoubleShortHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            double[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                double first = sortedArray[middleIndex];
                double second = sortedArray[middleIndex - 1];
                return (first + second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public double[] toSortedArray() {
            double[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableDoubleList toSortedList() {
            return DoubleArrayList.newList((DoubleIterable)this).sortThis();
        }

        public double[] toArray() {
            int size = DoubleShortHashMap.this.size();
            final double[] result = new double[size];
            DoubleShortHashMap.this.forEachKey(new DoubleProcedure(){
                private int index;

                public void value(double each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(double value) {
            return DoubleShortHashMap.this.containsKey(value);
        }

        public boolean containsAll(double ... source) {
            for (double item : source) {
                if (DoubleShortHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(DoubleIterable source) {
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                if (DoubleShortHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableDoubleList toList() {
            return DoubleArrayList.newList((DoubleIterable)this);
        }

        public MutableDoubleSet toSet() {
            return DoubleHashSet.newSet((DoubleIterable)this);
        }

        public MutableDoubleBag toBag() {
            return DoubleHashBag.newBag((DoubleIterable)this);
        }

        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0.0);
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1.0);
                }
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i])) continue;
                result = function.valueOf(result, DoubleShortHashMap.this.keys[i]);
            }
            return result;
        }

        public DoubleSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableDoubleSet toImmutable() {
            return DoubleSets.immutable.withAll((DoubleIterable)this);
        }

        public int size() {
            return DoubleShortHashMap.this.size();
        }

        public boolean isEmpty() {
            return DoubleShortHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleShortHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DoubleSet)) {
                return false;
            }
            DoubleSet other = (DoubleSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (DoubleShortHashMap.this.sentinelValues != null) {
                if (DoubleShortHashMap.this.sentinelValues.containsZeroKey) {
                    result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32);
                }
                if (DoubleShortHashMap.this.sentinelValues.containsOneKey) {
                    result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32);
                }
            }
            for (int i = 0; i < DoubleShortHashMap.this.keys.length; ++i) {
                if (!DoubleShortHashMap.isNonSentinel(DoubleShortHashMap.this.keys[i])) continue;
                result += (int)(Double.doubleToLongBits(DoubleShortHashMap.this.keys[i]) ^ Double.doubleToLongBits(DoubleShortHashMap.this.keys[i]) >>> 32);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleShortHashMap.this.sentinelValues != null) {
                    if (DoubleShortHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0));
                        first = false;
                    }
                    if (DoubleShortHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0));
                        first = false;
                    }
                }
                for (double key : DoubleShortHashMap.this.keys) {
                    if (!DoubleShortHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements DoubleIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleShortHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleShortHashMap.this.containsKey(0.0)) {
                    return 0.0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleShortHashMap.this.containsKey(1.0)) {
                    return 1.0;
                }
            }
            double[] keys = DoubleShortHashMap.this.keys;
            while (!DoubleShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    private class KeysView
    extends AbstractLazyDoubleIterable {
        private KeysView() {
        }

        public DoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            DoubleShortHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalShortIterator
    implements ShortIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleShortHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleShortHashMap.this.containsKey(0.0)) {
                    return DoubleShortHashMap.this.get(0.0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleShortHashMap.this.containsKey(1.0)) {
                    return DoubleShortHashMap.this.get(1.0);
                }
            }
            double[] keys = DoubleShortHashMap.this.keys;
            while (!DoubleShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            short result = DoubleShortHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private short zeroValue;
        private short oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(short value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

