/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatIntProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.factory.primitive.FloatSets;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableFloatSingletonSet
implements ImmutableFloatSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final float element;

    ImmutableFloatSingletonSet(float element) {
        this.element = element;
    }

    public ImmutableFloatSet newWith(float element) {
        return FloatSets.immutable.with(new float[]{this.element, element});
    }

    public ImmutableFloatSet newWithout(float element) {
        return Float.compare(this.element, element) == 0 ? FloatSets.immutable.with() : this;
    }

    public ImmutableFloatSet newWithAll(FloatIterable elements) {
        return FloatHashSet.newSet(elements).with(this.element).toImmutable();
    }

    public ImmutableFloatSet newWithoutAll(FloatIterable elements) {
        return elements.contains(this.element) ? FloatSets.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(float value) {
        return Float.compare(this.element, value) == 0;
    }

    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (Float.compare(this.element, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.element, value) == 0) continue;
            return false;
        }
        return true;
    }

    public void forEach(FloatProcedure procedure) {
        procedure.value(this.element);
    }

    public ImmutableFloatSet select(FloatPredicate predicate) {
        return predicate.accept(this.element) ? FloatHashSet.newSetWith(this.element).toImmutable() : new FloatHashSet().toImmutable();
    }

    public ImmutableFloatSet reject(FloatPredicate predicate) {
        return predicate.accept(this.element) ? new FloatHashSet().toImmutable() : FloatHashSet.newSetWith(this.element).toImmutable();
    }

    public <V> ImmutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        return UnifiedSet.newSetWith(function.valueOf(this.element)).toImmutable();
    }

    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.element);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(float item) {
        return Float.compare(this.element, item) == 0 ? 1 : 0;
    }

    public void forEachWithOccurrences(FloatIntProcedure floatIntProcedure) {
        floatIntProcedure.value(this.element, 1);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    public int count(FloatPredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element);
    }

    public double sum() {
        return this.element;
    }

    public float min() {
        return this.element;
    }

    public float max() {
        return this.element;
    }

    public float maxIfEmpty(float defaultValue) {
        return this.element;
    }

    public float minIfEmpty(float defaultValue) {
        return this.element;
    }

    public double average() {
        return this.element;
    }

    public double median() {
        return this.element;
    }

    public float[] toSortedArray() {
        return new float[]{this.element};
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.element);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.element);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.element);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatSet)) {
            return false;
        }
        FloatSet set = (FloatSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.element) ^ 1;
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.element);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.element);
    }

    public FloatSet freeze() {
        return this;
    }

    public ImmutableFloatSet toImmutable() {
        return this;
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public float[] toArray() {
        return new float[]{this.element};
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FloatIterator floatIterator() {
        return FloatHashSet.newSetWith(this.element).floatIterator();
    }
}

