/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.tuple.primitive;

import com.gs.collections.api.tuple.primitive.IntFloatPair;

public class IntFloatPairImpl
implements IntFloatPair {
    private static final long serialVersionUID = 1L;
    private final int one;
    private final float two;

    IntFloatPairImpl(int newOne, float newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    public int getOne() {
        return this.one;
    }

    public float getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntFloatPair)) {
            return false;
        }
        IntFloatPair that = (IntFloatPair)o;
        return this.one == that.getOne() && Float.compare(this.two, that.getTwo()) == 0;
    }

    public int hashCode() {
        return 29 * this.one + Float.floatToIntBits(this.two);
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    public int compareTo(IntFloatPair that) {
        int i;
        int n = this.one < that.getOne() ? -1 : (i = this.one > that.getOne() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        return Float.compare(this.two, that.getTwo());
    }
}

