/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.lazy.primitive.CollectByteToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectByteIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyByteIterate {
    private static final LazyByteIterable EMPTY_ITERABLE = ByteLists.immutable.of().asLazy();

    private LazyByteIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyByteIterable adapt(ByteIterable iterable) {
        return new LazyByteIterableAdapter(iterable);
    }

    public static LazyByteIterable select(ByteIterable iterable, BytePredicate predicate) {
        return new SelectByteIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(ByteIterable iterable, ByteToObjectFunction<? extends V> function) {
        return new CollectByteToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(ByteIterable iterable, BytePredicate predicate, ByteToObjectFunction<? extends V> function) {
        return LazyByteIterate.select(iterable, predicate).collect(function);
    }

    public static LazyByteIterable empty() {
        return EMPTY_ITERABLE;
    }
}

