/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.list.primitive.ImmutableDoubleList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedDoubleCollection;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseDoubleIterable;
import com.gs.collections.impl.list.mutable.primitive.UnmodifiableDoubleList;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedDoubleList
extends AbstractSynchronizedDoubleCollection
implements MutableDoubleList {
    private static final long serialVersionUID = 1L;

    SynchronizedDoubleList(MutableDoubleList list) {
        super((MutableDoubleCollection)list);
    }

    SynchronizedDoubleList(MutableDoubleList list, Object newLock) {
        super((MutableDoubleCollection)list, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableDoubleList getMutableDoubleList() {
        return (MutableDoubleList)this.getDoubleCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFirst() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLast() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(double value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().indexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(double value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().lastIndexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAtIndex(int index, double element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleList().addAtIndex(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAllAtIndex(int index, double ... source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAllAtIndex(int index, DoubleIterable source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double removeAtIndex(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().removeAtIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double set(int index, double element) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleList with(double element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleList().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleList without(double element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleList().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleList withAll(DoubleIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleList().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleList withoutAll(DoubleIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleList().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleList select(DoublePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleList reject(DoublePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableList<V> collect(DoubleToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleList sortThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleList().sortThis();
        }
        return this;
    }

    public double dotProduct(DoubleList list) {
        return this.getMutableDoubleList().dotProduct(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherList) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().equals(otherList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyDoubleIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }
    }

    public MutableDoubleList asUnmodifiable() {
        return new UnmodifiableDoubleList(this);
    }

    public MutableDoubleList asSynchronized() {
        return this;
    }

    public ImmutableDoubleList toImmutable() {
        int size = this.size();
        if (size == 0) {
            return DoubleLists.immutable.with();
        }
        if (size == 1) {
            return DoubleLists.immutable.with(this.getFirst());
        }
        return DoubleLists.immutable.with(this.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleList reverseThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleList().reverseThis();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleList toReversed() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleList().toReversed();
        }
    }

    public LazyDoubleIterable asReversed() {
        return ReverseDoubleIterable.adapt((DoubleList)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(DoubleIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleList().forEachWithIndex(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableDoubleList().injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectIntoWithIndex(T injectedValue, ObjectDoubleIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getMutableDoubleList().injectIntoWithIndex(injectedValue, function);
        }
    }

    public MutableDoubleList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

