/*
 * Decompiled with CFR 0.152.
 */
package rat.report.analyser;

import rat.analysis.IHeaderMatcher;
import rat.document.IDocumentAnalyser;
import rat.document.IDocumentMatcher;
import rat.document.impl.guesser.ArchiveGuesser;
import rat.document.impl.guesser.BinaryGuesser;
import rat.document.impl.guesser.NoteGuesser;
import rat.document.impl.util.ConditionalAnalyser;
import rat.document.impl.util.DocumentAnalyserMultiplexer;
import rat.document.impl.util.DocumentMatcherMultiplexer;
import rat.document.impl.util.MatchNegator;
import rat.report.analyser.ConstantClaimAnalyser;
import rat.report.analyser.DocumentHeaderAnalyser;
import rat.report.analyser.ReadableArchiveAnalyser;
import rat.report.claim.IClaimReporter;

public class DefaultAnalyserFactory {
    public static final IDocumentAnalyser createArchiveTypeAnalyser(IClaimReporter reporter) {
        ConstantClaimAnalyser constantClaimAnalyser = new ConstantClaimAnalyser(reporter, "type", "archive", false);
        return constantClaimAnalyser;
    }

    public static final IDocumentAnalyser createNoticeTypeAnalyser(IClaimReporter reporter) {
        ConstantClaimAnalyser constantClaimAnalyser = new ConstantClaimAnalyser(reporter, "type", "notice", false);
        return constantClaimAnalyser;
    }

    public static final IDocumentAnalyser createBinaryTypeAnalyser(IClaimReporter reporter) {
        ConstantClaimAnalyser constantClaimAnalyser = new ConstantClaimAnalyser(reporter, "type", "binary", false);
        return constantClaimAnalyser;
    }

    public static final IDocumentAnalyser createStandardTypeAnalyser(IClaimReporter reporter) {
        ConstantClaimAnalyser constantClaimAnalyser = new ConstantClaimAnalyser(reporter, "type", "standard", false);
        return constantClaimAnalyser;
    }

    public static final IDocumentAnalyser createDefaultBinaryAnalyser(IClaimReporter reporter) {
        IDocumentAnalyser result = DefaultAnalyserFactory.createBinaryTypeAnalyser(reporter);
        return result;
    }

    public static final IDocumentAnalyser createDefaultNoticeAnalyser(IClaimReporter reporter) {
        IDocumentAnalyser result = DefaultAnalyserFactory.createNoticeTypeAnalyser(reporter);
        return result;
    }

    public static final IDocumentAnalyser createDefaultArchiveAnalyser(IClaimReporter reporter) {
        IDocumentAnalyser[] components = new IDocumentAnalyser[]{DefaultAnalyserFactory.createArchiveTypeAnalyser(reporter), new ReadableArchiveAnalyser(reporter)};
        DocumentAnalyserMultiplexer result = new DocumentAnalyserMultiplexer(components);
        return result;
    }

    public static final IDocumentAnalyser createDefaultStandardAnalyser(IClaimReporter reporter, IHeaderMatcher matcher) {
        IDocumentAnalyser[] components = new IDocumentAnalyser[]{DefaultAnalyserFactory.createStandardTypeAnalyser(reporter), new DocumentHeaderAnalyser(matcher, reporter)};
        DocumentAnalyserMultiplexer result = new DocumentAnalyserMultiplexer(components);
        return result;
    }

    public static final IDocumentAnalyser createDefaultAnalyser(IClaimReporter reporter, IHeaderMatcher matcher) {
        IDocumentAnalyser binaryAnalyser = DefaultAnalyserFactory.createDefaultBinaryAnalyser(reporter);
        IDocumentAnalyser archiveAnalyser = DefaultAnalyserFactory.createDefaultArchiveAnalyser(reporter);
        IDocumentAnalyser noticeAnalyser = DefaultAnalyserFactory.createDefaultNoticeAnalyser(reporter);
        IDocumentAnalyser standardAnalyser = DefaultAnalyserFactory.createDefaultStandardAnalyser(reporter, matcher);
        return DefaultAnalyserFactory.createDefaultAnalyser(binaryAnalyser, archiveAnalyser, noticeAnalyser, standardAnalyser);
    }

    public static IDocumentAnalyser createDefaultAnalyser(IDocumentAnalyser binaryAnalyser, IDocumentAnalyser archiveAnalyser, IDocumentAnalyser noticeAnalyser, IDocumentAnalyser standardAnalyser) {
        BinaryGuesser binaryGuesser = new BinaryGuesser();
        ArchiveGuesser archiveGuesser = new ArchiveGuesser();
        NoteGuesser noteGuesser = new NoteGuesser();
        return DefaultAnalyserFactory.createDefaultAnalyser(binaryAnalyser, archiveAnalyser, noticeAnalyser, standardAnalyser, binaryGuesser, archiveGuesser, noteGuesser);
    }

    public static IDocumentAnalyser createDefaultAnalyser(IDocumentAnalyser binaryAnalyser, IDocumentAnalyser archiveAnalyser, IDocumentAnalyser noticeAnalyser, IDocumentAnalyser standardAnalyser, IDocumentMatcher binaryGuesser, IDocumentMatcher archiveGuesser, IDocumentMatcher noteGuesser) {
        ConditionalAnalyser binaryMatcher = new ConditionalAnalyser(binaryGuesser, binaryAnalyser);
        ConditionalAnalyser noticeMatcher = new ConditionalAnalyser(noteGuesser, noticeAnalyser);
        ConditionalAnalyser archiveMatcher = new ConditionalAnalyser(archiveGuesser, archiveAnalyser);
        IDocumentMatcher[] matchers = new IDocumentMatcher[]{noticeMatcher, archiveMatcher, binaryMatcher};
        DocumentMatcherMultiplexer specialDocumentMatcher = new DocumentMatcherMultiplexer(matchers);
        MatchNegator documentMatcher = new MatchNegator(specialDocumentMatcher);
        ConditionalAnalyser result = new ConditionalAnalyser(documentMatcher, standardAnalyser);
        return result;
    }
}

