/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.xml;

import com.google.api.client.util.Beta;
import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Types;
import com.google.api.client.xml.Xml;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xmlpull.v1.XmlSerializer;

@Beta
public final class XmlNamespaceDictionary {
    private final HashMap<String, String> namespaceAliasToUriMap = new HashMap();
    private final HashMap<String, String> namespaceUriToAliasMap = new HashMap();

    public synchronized String getAliasForUri(String uri) {
        return this.namespaceUriToAliasMap.get(Preconditions.checkNotNull((Object)uri));
    }

    public synchronized String getUriForAlias(String alias) {
        return this.namespaceAliasToUriMap.get(Preconditions.checkNotNull((Object)alias));
    }

    public synchronized Map<String, String> getAliasToUriMap() {
        return Collections.unmodifiableMap(this.namespaceAliasToUriMap);
    }

    public synchronized Map<String, String> getUriToAliasMap() {
        return Collections.unmodifiableMap(this.namespaceUriToAliasMap);
    }

    public synchronized XmlNamespaceDictionary set(String alias, String uri) {
        String previousUri = null;
        String previousAlias = null;
        if (uri == null) {
            if (alias != null) {
                previousUri = this.namespaceAliasToUriMap.remove(alias);
            }
        } else if (alias == null) {
            previousAlias = this.namespaceUriToAliasMap.remove(uri);
        } else {
            previousUri = this.namespaceAliasToUriMap.put((String)Preconditions.checkNotNull((Object)alias), (String)Preconditions.checkNotNull((Object)uri));
            if (!uri.equals(previousUri)) {
                previousAlias = this.namespaceUriToAliasMap.put(uri, alias);
            } else {
                previousUri = null;
            }
        }
        if (previousUri != null) {
            this.namespaceUriToAliasMap.remove(previousUri);
        }
        if (previousAlias != null) {
            this.namespaceAliasToUriMap.remove(previousAlias);
        }
        return this;
    }

    public String toStringOf(String elementName, Object element) {
        try {
            StringWriter writer = new StringWriter();
            XmlSerializer serializer = Xml.createSerializer();
            serializer.setOutput((Writer)writer);
            this.serialize(serializer, elementName, element, false);
            return writer.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void serialize(XmlSerializer serializer, String elementNamespaceUri, String elementLocalName, Object element) throws IOException {
        this.serialize(serializer, elementNamespaceUri, elementLocalName, element, true);
    }

    public void serialize(XmlSerializer serializer, String elementName, Object element) throws IOException {
        this.serialize(serializer, elementName, element, true);
    }

    private void serialize(XmlSerializer serializer, String elementNamespaceUri, String elementLocalName, Object element, boolean errorOnUnknown) throws IOException {
        String elementAlias = elementNamespaceUri == null ? null : this.getAliasForUri(elementNamespaceUri);
        this.startDoc(serializer, element, errorOnUnknown, elementAlias).serialize(serializer, elementNamespaceUri, elementLocalName);
        serializer.endDocument();
    }

    private void serialize(XmlSerializer serializer, String elementName, Object element, boolean errorOnUnknown) throws IOException {
        int colon;
        String elementAlias = "";
        if (elementName != null && (colon = elementName.indexOf(58)) != -1) {
            elementAlias = elementName.substring(0, colon);
        }
        this.startDoc(serializer, element, errorOnUnknown, elementAlias).serialize(serializer, elementName);
        serializer.endDocument();
    }

    private ElementSerializer startDoc(XmlSerializer serializer, Object element, boolean errorOnUnknown, String elementAlias) throws IOException {
        serializer.startDocument(null, null);
        TreeSet<String> aliases = new TreeSet<String>();
        this.computeAliases(element, aliases);
        if (elementAlias != null) {
            aliases.add(elementAlias);
        }
        for (String alias : aliases) {
            String uri = this.getNamespaceUriForAliasHandlingUnknown(errorOnUnknown, alias);
            serializer.setPrefix(alias, uri);
        }
        return new ElementSerializer(element, errorOnUnknown);
    }

    private void computeAliases(Object element, SortedSet<String> aliases) {
        for (Map.Entry entry : Data.mapOf((Object)element).entrySet()) {
            boolean isAttribute;
            String name;
            Object value = entry.getValue();
            if (value == null || "text()".equals(name = (String)entry.getKey())) continue;
            int colon = name.indexOf(58);
            boolean bl = isAttribute = name.charAt(0) == '@';
            if (colon != -1 || !isAttribute) {
                String alias = colon == -1 ? "" : name.substring(name.charAt(0) == '@' ? 1 : 0, colon);
                aliases.add(alias);
            }
            Class<?> valueClass = value.getClass();
            if (isAttribute || Data.isPrimitive(valueClass) || valueClass.isEnum()) continue;
            if (value instanceof Iterable || valueClass.isArray()) {
                for (Object subValue : Types.iterableOf(value)) {
                    this.computeAliases(subValue, aliases);
                }
                continue;
            }
            this.computeAliases(value, aliases);
        }
    }

    String getNamespaceUriForAliasHandlingUnknown(boolean errorOnUnknown, String alias) {
        String result = this.getUriForAlias(alias);
        if (result == null) {
            Preconditions.checkArgument((!errorOnUnknown ? 1 : 0) != 0, (String)"unrecognized alias: %s", (Object[])new Object[]{alias.length() == 0 ? "(default)" : alias});
            return "http://unknown/" + alias;
        }
        return result;
    }

    String getNamespaceAliasForUriErrorOnUnknown(String namespaceUri) {
        String result = this.getAliasForUri(namespaceUri);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"invalid XML: no alias declared for namesapce <%s>; work-around by setting XML namepace directly by calling the set method of %s", (Object[])new Object[]{namespaceUri, XmlNamespaceDictionary.class.getName()});
        return result;
    }

    static String toSerializedValue(Object value) {
        if (value instanceof Float) {
            Float f = (Float)value;
            if (f.floatValue() == Float.POSITIVE_INFINITY) {
                return "INF";
            }
            if (f.floatValue() == Float.NEGATIVE_INFINITY) {
                return "-INF";
            }
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            if (d == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof DateTime) {
            return ((DateTime)value).toStringRfc3339();
        }
        if (value instanceof Enum) {
            return FieldInfo.of((Enum)((Enum)value)).getName();
        }
        throw new IllegalArgumentException("unrecognized value type: " + value.getClass());
    }

    @Beta
    class ElementSerializer {
        private final boolean errorOnUnknown;
        Object textValue = null;
        final List<String> attributeNames = new ArrayList<String>();
        final List<Object> attributeValues = new ArrayList<Object>();
        final List<String> subElementNames = new ArrayList<String>();
        final List<Object> subElementValues = new ArrayList<Object>();

        ElementSerializer(Object elementValue, boolean errorOnUnknown) {
            this.errorOnUnknown = errorOnUnknown;
            Class<?> valueClass = elementValue.getClass();
            if (Data.isPrimitive(valueClass) && !Data.isNull((Object)elementValue)) {
                this.textValue = elementValue;
            } else if (valueClass.isEnum() && !Data.isNull((Object)elementValue)) {
                this.textValue = elementValue;
            } else {
                for (Map.Entry entry : Data.mapOf((Object)elementValue).entrySet()) {
                    Object fieldValue = entry.getValue();
                    if (fieldValue == null || Data.isNull(fieldValue)) continue;
                    String fieldName = (String)entry.getKey();
                    if ("text()".equals(fieldName)) {
                        this.textValue = fieldValue;
                        continue;
                    }
                    if (fieldName.charAt(0) == '@') {
                        this.attributeNames.add(fieldName.substring(1));
                        this.attributeValues.add(fieldValue);
                        continue;
                    }
                    this.subElementNames.add(fieldName);
                    this.subElementValues.add(fieldValue);
                }
            }
        }

        void serialize(XmlSerializer serializer, String elementName) throws IOException {
            String elementLocalName = null;
            String elementNamespaceUri = null;
            if (elementName != null) {
                int colon = elementName.indexOf(58);
                elementLocalName = elementName.substring(colon + 1);
                String alias = colon == -1 ? "" : elementName.substring(0, colon);
                elementNamespaceUri = XmlNamespaceDictionary.this.getNamespaceUriForAliasHandlingUnknown(this.errorOnUnknown, alias);
            }
            this.serialize(serializer, elementNamespaceUri, elementLocalName);
        }

        void serialize(XmlSerializer serializer, String elementNamespaceUri, String elementLocalName) throws IOException {
            int i;
            boolean errorOnUnknown = this.errorOnUnknown;
            if (elementLocalName == null) {
                if (errorOnUnknown) {
                    throw new IllegalArgumentException("XML name not specified");
                }
                elementLocalName = "unknownName";
            }
            serializer.startTag(elementNamespaceUri, elementLocalName);
            int num = this.attributeNames.size();
            for (i = 0; i < num; ++i) {
                String attributeName = this.attributeNames.get(i);
                int colon = attributeName.indexOf(58);
                String attributeLocalName = attributeName.substring(colon + 1);
                String attributeNamespaceUri = colon == -1 ? null : XmlNamespaceDictionary.this.getNamespaceUriForAliasHandlingUnknown(errorOnUnknown, attributeName.substring(0, colon));
                serializer.attribute(attributeNamespaceUri, attributeLocalName, XmlNamespaceDictionary.toSerializedValue(this.attributeValues.get(i)));
            }
            if (this.textValue != null) {
                serializer.text(XmlNamespaceDictionary.toSerializedValue(this.textValue));
            }
            num = this.subElementNames.size();
            for (i = 0; i < num; ++i) {
                Object subElementValue = this.subElementValues.get(i);
                String subElementName = this.subElementNames.get(i);
                Class<?> valueClass = subElementValue.getClass();
                if (subElementValue instanceof Iterable || valueClass.isArray()) {
                    for (Object subElement : Types.iterableOf((Object)subElementValue)) {
                        if (subElement == null || Data.isNull(subElement)) continue;
                        new ElementSerializer(subElement, errorOnUnknown).serialize(serializer, subElementName);
                    }
                    continue;
                }
                new ElementSerializer(subElementValue, errorOnUnknown).serialize(serializer, subElementName);
            }
            serializer.endTag(elementNamespaceUri, elementLocalName);
        }
    }
}

