/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.signature;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignature;

public class SignatureEdDSA
extends AbstractSignature {
    SignatureEdDSA() {
        super((Signature)SignatureEdDSA.getEngine(), KeyType.ED25519.toString());
    }

    private static EdDSAEngine getEngine() {
        try {
            return new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSHRuntimeException(e);
        }
    }

    @Override
    public byte[] encode(byte[] signature) {
        return signature;
    }

    @Override
    public boolean verify(byte[] sig) {
        try {
            return this.signature.verify(this.extractSig(sig, "ssh-ed25519"));
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public static class Factory
    implements Factory.Named<net.schmizz.sshj.signature.Signature> {
        @Override
        public String getName() {
            return KeyType.ED25519.toString();
        }

        @Override
        public net.schmizz.sshj.signature.Signature create() {
            return new SignatureEdDSA();
        }
    }
}

