/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model.select;

import com.obs.services.internal.xml.OBSXMLBuilder;
import com.obs.services.model.select.ExpressionType;
import com.obs.services.model.select.InputSerialization;
import com.obs.services.model.select.OutputSerialization;
import com.obs.services.model.select.RequestProgress;
import com.obs.services.model.select.ScanRange;
import com.obs.services.model.select.SelectObjectException;

public class SelectObjectRequest {
    private String bucketName;
    private String key;
    private String expression;
    private String expressionType;
    private RequestProgress requestProgress;
    private InputSerialization inputSerialization;
    private OutputSerialization outputSerialization;
    private ScanRange scanRange;

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKey() {
        return this.key;
    }

    public String getExpression() {
        return this.expression;
    }

    public SelectObjectRequest withBucketName(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public SelectObjectRequest withKey(String key) {
        this.key = key;
        return this;
    }

    public SelectObjectRequest withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    public SelectObjectRequest withRequestProgress(RequestProgress requestProgress) {
        this.requestProgress = requestProgress;
        return this;
    }

    public SelectObjectRequest withExpressionType(ExpressionType expressionType) {
        this.expressionType = expressionType == null ? null : expressionType.toString();
        return this;
    }

    public SelectObjectRequest withInputSerialization(InputSerialization inputSerialization) {
        this.inputSerialization = inputSerialization;
        return this;
    }

    public SelectObjectRequest withOutputSerialization(OutputSerialization outputSerialization) {
        this.outputSerialization = outputSerialization;
        return this;
    }

    public SelectObjectRequest withScanRange(ScanRange scanRange) {
        this.scanRange = scanRange;
        return this;
    }

    public String convertToXml() throws SelectObjectException {
        try {
            OBSXMLBuilder xmlBuilder = OBSXMLBuilder.create("SelectObjectContentRequest");
            if (this.expressionType != null) {
                xmlBuilder.elem("ExpressionType").text(this.expressionType);
            }
            if (this.expression != null) {
                xmlBuilder.elem("Expression").text(this.expression);
            }
            if (this.requestProgress != null) {
                this.requestProgress.appendToXml(xmlBuilder);
            }
            if (this.inputSerialization != null) {
                this.inputSerialization.appendToXml(xmlBuilder);
            }
            if (this.outputSerialization != null) {
                this.outputSerialization.appendToXml(xmlBuilder);
            }
            if (this.scanRange != null) {
                this.scanRange.appendToXml(xmlBuilder);
            }
            return xmlBuilder.asString();
        }
        catch (Exception e) {
            throw new SelectObjectException("Wrong request", e.getMessage());
        }
    }
}

