/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.router.client.loabalancer;

import com.huaweicloud.router.client.loabalancer.ServiceInstanceFilter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.core.Ordered;
import reactor.core.publisher.Flux;

public class RouterServiceInstanceListSupplier
implements ServiceInstanceListSupplier {
    private List<ServiceInstanceFilter> filters;
    private final ServiceInstanceListSupplier delegate;

    public RouterServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
        this.delegate = delegate;
    }

    @Autowired
    public void setFilters(List<ServiceInstanceFilter> filters) {
        this.filters = filters;
    }

    @PostConstruct
    private void init() {
        if (this.filters != null) {
            Collections.sort(this.filters, Comparator.comparingInt(Ordered::getOrder));
        }
    }

    public String getServiceId() {
        return this.delegate.getServiceId();
    }

    public Flux<List<ServiceInstance>> get(Request request) {
        Flux result = this.delegate.get(request);
        return result.map(instances -> this.filter((List<ServiceInstance>)instances, (Request<?>)request));
    }

    public Flux<List<ServiceInstance>> get() {
        return (Flux)this.delegate.get();
    }

    private List<ServiceInstance> filter(List<ServiceInstance> instances, Request<?> request) {
        if (this.filters == null) {
            return instances;
        }
        List<ServiceInstance> filteredInstances = instances;
        for (ServiceInstanceFilter instanceFilter : this.filters) {
            filteredInstances = instanceFilter.filter(this, filteredInstances, request);
        }
        return filteredInstances;
    }
}

