/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.router.client.track;

import com.huaweicloud.router.client.track.RouterHandlerInterceptor;
import com.huaweicloud.router.client.track.RouterRequestInterceptor;
import com.huaweicloud.router.client.track.RouterRestTemplateInterceptor;
import feign.RequestInterceptor;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class RouterWebAutoConfiguration {
    @Bean
    public RequestInterceptor requestInterceptor() {
        return new RouterRequestInterceptor();
    }

    @Bean
    public ClientHttpRequestInterceptor restTemplateInterceptor(@Autowired(required=false) @LoadBalanced List<RestTemplate> restTemplates) {
        RouterRestTemplateInterceptor interceptor = new RouterRestTemplateInterceptor();
        if (restTemplates != null) {
            restTemplates.forEach(restTemplate -> restTemplate.getInterceptors().add(interceptor));
        }
        return interceptor;
    }

    @Configuration
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    static class WebMvcConfigurerEnable {
        WebMvcConfigurerEnable() {
        }

        @Bean
        public WebMvcConfigurer canaryWebMvcConfigurer() {
            return new WebMvcConfigurer(){

                public void addInterceptors(InterceptorRegistry registry) {
                    registry.addInterceptor((HandlerInterceptor)new RouterHandlerInterceptor()).addPathPatterns(new String[]{"/**"});
                }
            };
        }
    }
}

