/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.discovery;

import com.huaweicloud.common.exception.ServiceCombRuntimeException;
import com.huaweicloud.common.transport.ServiceCombAkSkProperties;
import com.huaweicloud.common.transport.ServiceCombRBACProperties;
import com.huaweicloud.common.transport.ServiceCombSSLProperties;
import com.huaweicloud.servicecomb.discovery.ConditionalOnServiceCombDiscoveryEnabled;
import com.huaweicloud.servicecomb.discovery.client.ServiceCombClient;
import com.huaweicloud.servicecomb.discovery.client.ServiceCombClientBuilder;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryClient;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryProperties;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombWatch;
import com.huaweicloud.servicecomb.discovery.registry.TagsProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnServiceCombDiscoveryEnabled
@AutoConfigureBefore(value={SimpleDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class})
public class ServiceCombDiscoveryClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ServiceCombDiscoveryProperties serviceCombProperties() {
        return new ServiceCombDiscoveryProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public TagsProperties tagsProperties() {
        return new TagsProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceCombSSLProperties serviceCombSSLProperties() {
        return new ServiceCombSSLProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceCombRBACProperties serviceCombRBACProperties() {
        return new ServiceCombRBACProperties();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.servicecomb.discovery.enabled"}, matchIfMissing=true)
    public ServiceCombClient serviceCombClient(ServiceCombDiscoveryProperties serviceCombProperties, ServiceCombRBACProperties serviceCombRBACProperties, ServiceCombAkSkProperties serviceCombAkSkProperties, ServiceCombSSLProperties serviceCombSSLProperties) {
        ServiceCombClientBuilder builder = new ServiceCombClientBuilder();
        if (!StringUtils.isEmpty((Object)serviceCombAkSkProperties.getEnable())) {
            throw new ServiceCombRuntimeException("config credentials.enable has change to credentials.enabled ,old names are no longer supported, please change it.");
        }
        builder.setUrl(serviceCombProperties.getAddress()).setServiceCombRBACProperties(serviceCombRBACProperties).setServiceCombAkSkProperties(serviceCombAkSkProperties).setServiceCombSSLProperties(serviceCombSSLProperties);
        return builder.createServiceCombClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public DiscoveryClient serviceCombDiscoveryClient(ServiceCombDiscoveryProperties discoveryProperties, ServiceCombClient serviceCombClient) {
        return new ServiceCombDiscoveryClient(discoveryProperties, serviceCombClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceCombWatch serviceCombWatch(ServiceCombDiscoveryProperties discoveryProperties) {
        return new ServiceCombWatch(discoveryProperties);
    }
}

