/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.discovery;

import com.huaweicloud.servicecomb.discovery.client.model.DataCenter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="spring.cloud.servicecomb.discovery")
public class ServiceCombDiscoveryProperties {
    private boolean enabled = true;
    private boolean watch = true;
    private String address;
    private String appName;
    @Value(value="${spring.cloud.servicecomb.discovery.serviceName:${spring.application.name:}}")
    private String serviceName;
    @Value(value="${server.env:}")
    private String environment;
    private String version;
    private String hostname;
    private boolean preferIpAddress;
    private boolean healthCheck = true;
    private int healthCheckInterval;
    private int refreshInterval = 30000;
    private boolean autoDiscovery = false;
    private boolean allowCrossApp = false;
    @Value(value="${server.publishAddress:}")
    private String serverAddress;
    @Value(value="${server.port}")
    private String port;
    private DataCenter datacenter;

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public DataCenter getDatacenter() {
        return this.datacenter;
    }

    public void setDatacenter(DataCenter datacenter) {
        this.datacenter = datacenter;
    }

    public String getAppName() {
        if (null == this.appName) {
            return "default";
        }
        return this.appName;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public boolean isPreferIpAddress() {
        return this.preferIpAddress;
    }

    public void setPreferIpAddress(boolean preferIpAddress) {
        this.preferIpAddress = preferIpAddress;
    }

    public boolean isHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(boolean healthCheck) {
        this.healthCheck = healthCheck;
    }

    public int getHealthCheckInterval() {
        if (this.healthCheckInterval == 0) {
            this.healthCheckInterval = 10;
        }
        return this.healthCheckInterval;
    }

    public void setHealthCheckInterval(int healthCheckInterval) {
        this.healthCheckInterval = healthCheckInterval;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public boolean isAutoDiscovery() {
        return this.autoDiscovery;
    }

    public void setAutoDiscovery(boolean autoDiscovery) {
        this.autoDiscovery = autoDiscovery;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public boolean isAllowCrossApp() {
        return this.allowCrossApp;
    }

    public void setAllowCrossApp(boolean allowCrossApp) {
        this.allowCrossApp = allowCrossApp;
    }

    public boolean isWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public String toString() {
        return "ServiceCombDiscoveryProperties{enabled=" + this.enabled + ", watch=" + this.watch + ", address='" + this.address + '\'' + ", appName='" + this.appName + '\'' + ", serviceName='" + this.serviceName + '\'' + ", environment='" + this.environment + '\'' + ", version='" + this.version + '\'' + ", hostname='" + this.hostname + '\'' + ", preferIpAddress=" + this.preferIpAddress + ", healthCheck=" + this.healthCheck + ", healthCheckInterval=" + this.healthCheckInterval + ", autoDiscovery=" + this.autoDiscovery + ", allowCrossApp=" + this.allowCrossApp + ", port='" + this.port + '\'' + ", datacenter=" + this.datacenter + '}';
    }
}

