/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.discovery;

import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryProperties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;

public class ServiceCombWatch
implements ApplicationEventPublisherAware,
SmartLifecycle {
    private ServiceCombDiscoveryProperties discoveryProperties;
    private final AtomicBoolean isActive = new AtomicBoolean(false);
    private ApplicationEventPublisher publisher;
    private ScheduledFuture<?> watchFuture;
    private final TaskScheduler taskScheduler = new ConcurrentTaskScheduler(Executors.newSingleThreadScheduledExecutor());
    private final AtomicLong index = new AtomicLong(0L);

    public ServiceCombWatch(ServiceCombDiscoveryProperties discoveryProperties) {
        this.discoveryProperties = discoveryProperties;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public void start() {
        if (this.isActive.compareAndSet(false, true)) {
            this.watchFuture = this.taskScheduler.scheduleWithFixedDelay(() -> this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)this.index.getAndIncrement())), (long)this.discoveryProperties.getRefreshInterval());
        }
    }

    public void stop() {
        if (this.isActive.compareAndSet(true, false) && this.watchFuture != null) {
            this.watchFuture.cancel(true);
        }
    }

    public boolean isRunning() {
        return this.isActive.get();
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable runnable) {
        this.stop();
        runnable.run();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }
}

