/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.registry;

import com.huaweicloud.common.cache.RegisterCache;
import com.huaweicloud.common.exception.ServiceCombException;
import com.huaweicloud.servicecomb.discovery.client.ServiceCombClient;
import com.huaweicloud.servicecomb.discovery.client.model.HeardBeatStatus;
import com.huaweicloud.servicecomb.discovery.client.model.Microservice;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;

public class HeartbeatScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatScheduler.class);
    private final TaskScheduler scheduler = new ConcurrentTaskScheduler(Executors.newSingleThreadScheduledExecutor());
    private final Map<String, ScheduledFuture> heartbeatRequestMap = new ConcurrentHashMap<String, ScheduledFuture>();
    private ServiceCombDiscoveryProperties serviceCombDiscoveryProperties;
    private ServiceCombClient serviceCombClient;
    private AtomicBoolean heartbeatLog = new AtomicBoolean(true);

    public HeartbeatScheduler(ServiceCombDiscoveryProperties serviceCombDiscoveryProperties, ServiceCombClient serviceCombClient) {
        this.serviceCombDiscoveryProperties = serviceCombDiscoveryProperties;
        this.serviceCombClient = serviceCombClient;
    }

    public void add(Microservice microservice, Function<Microservice, Boolean> registryFunc) {
        ScheduledFuture currentTask = this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                HeardBeatStatus result = this.serviceCombClient.heartbeat(RegisterCache.getServiceID(), RegisterCache.getInstanceID());
                if (result == HeardBeatStatus.FAILED) {
                    LOGGER.info("retry registry to service center.");
                    String oldInstanceID = RegisterCache.getInstanceID();
                    if (((Boolean)registryFunc.apply(microservice)).booleanValue()) {
                        this.refreshLocalMap(RegisterCache.getInstanceID(), this.heartbeatRequestMap.remove(oldInstanceID));
                    }
                }
                if (this.heartbeatLog.get()) {
                    LOGGER.info("heartbeat success.");
                    this.heartbeatLog.compareAndSet(true, false);
                }
            }
            catch (ServiceCombException e) {
                this.heartbeatLog.compareAndSet(false, true);
                LOGGER.warn("heartbeat failed.", (Throwable)e);
            }
        }, (long)(this.serviceCombDiscoveryProperties.getHealthCheckInterval() * 1000));
        this.refreshLocalMap(RegisterCache.getInstanceID(), currentTask);
    }

    public void remove() {
        ScheduledFuture scheduled = this.heartbeatRequestMap.remove(RegisterCache.getInstanceID());
        if (null != scheduled) {
            scheduled.cancel(true);
        }
    }

    private void refreshLocalMap(String instanceId, ScheduledFuture currentTask) {
        ScheduledFuture preScheduled = this.heartbeatRequestMap.put(instanceId, currentTask);
        if (null != preScheduled) {
            preScheduled.cancel(true);
        }
    }
}

