/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.registry;

import com.huaweicloud.common.cache.RegisterCache;
import com.huaweicloud.common.exception.ServiceCombException;
import com.huaweicloud.common.schema.ServiceCombSwaggerHandler;
import com.huaweicloud.servicecomb.discovery.client.ServiceCombClient;
import com.huaweicloud.servicecomb.discovery.client.model.Microservice;
import com.huaweicloud.servicecomb.discovery.client.model.MicroserviceInstance;
import com.huaweicloud.servicecomb.discovery.client.model.MicroserviceInstanceSingleResponse;
import com.huaweicloud.servicecomb.discovery.client.model.SchemaResponse;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryProperties;
import com.huaweicloud.servicecomb.discovery.registry.HeartbeatScheduler;
import com.huaweicloud.servicecomb.discovery.registry.RegistryHandler;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombRegistration;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombWatcher;
import com.huaweicloud.servicecomb.discovery.registry.TagsProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;

public class ServiceCombServiceRegistry
implements ServiceRegistry<ServiceCombRegistration> {
    @Autowired(required=false)
    private ServiceCombSwaggerHandler serviceCombSwaggerHandler;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombServiceRegistry.class);
    private ServiceCombDiscoveryProperties serviceCombDiscoveryProperties;
    private ServiceCombClient serviceCombClient;
    private HeartbeatScheduler heartbeatScheduler;
    private TagsProperties tagsProperties;
    private String serviceID = null;
    private String instanceID = null;
    private ServiceCombWatcher serviceCombWatcher;
    private ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r);
        thread.setName("com.huaweicloud.registry");
        thread.setDaemon(true);
        return thread;
    });

    public ServiceCombServiceRegistry(ServiceCombClient serviceCombClient, HeartbeatScheduler heartbeatScheduler, ServiceCombDiscoveryProperties serviceCombDiscoveryProperties, ServiceCombWatcher serviceCombWatcher, TagsProperties tagsProperties) {
        this.serviceCombWatcher = serviceCombWatcher;
        this.tagsProperties = tagsProperties;
        this.serviceCombClient = serviceCombClient;
        this.heartbeatScheduler = heartbeatScheduler;
        this.serviceCombDiscoveryProperties = serviceCombDiscoveryProperties;
    }

    public void register(ServiceCombRegistration registration) {
        this.asyncRegister(registration);
    }

    private void asyncRegister(ServiceCombRegistration registration) {
        this.EXECUTOR.execute(() -> {
            try {
                Microservice microservice = this.getMicroservice(registration);
                this.loopRegister(microservice);
                this.doWatch();
                this.heartbeatScheduler.add(microservice, this::doRegister);
            }
            catch (Throwable e) {
                LOGGER.error("Unexpected exception in register. ", e);
            }
        });
    }

    private void doWatch() {
        if (!this.serviceCombDiscoveryProperties.isWatch()) {
            return;
        }
        try {
            URI uri = new URI(this.serviceCombClient.getUrl());
            String url = uri.getHost() + (uri.getPort() == -1 ? "" : ":" + uri.getPort()) + "/v4/" + "default" + "/registry/microservices/" + this.serviceID + "/watcher";
            this.serviceCombWatcher.start(url);
        }
        catch (URISyntaxException e) {
            LOGGER.error("parse url error");
        }
    }

    private void loopRegister(Microservice microservice) {
        while (!this.doRegister(microservice)) {
        }
    }

    private Microservice getMicroservice(ServiceCombRegistration registration) {
        Microservice microservice = RegistryHandler.buildMicroservice(registration);
        if (this.serviceCombSwaggerHandler != null) {
            this.serviceCombSwaggerHandler.init(this.serviceCombDiscoveryProperties.getAppName(), this.serviceCombDiscoveryProperties.getServiceName());
            microservice.setSchemas(this.serviceCombSwaggerHandler.getSchemaIds());
        }
        return microservice;
    }

    private boolean doRegister(Microservice microservice) {
        try {
            this.serviceID = this.serviceCombClient.getServiceId(microservice);
            List<String> schemas = null;
            if (null == this.serviceID) {
                this.serviceID = this.serviceCombClient.registerMicroservice(microservice);
                schemas = microservice.getSchemas();
            }
            if (this.serviceCombSwaggerHandler != null) {
                if (schemas == null) {
                    schemas = this.filterSchema(this.serviceCombSwaggerHandler.getSchemasSummaryMap());
                }
                this.serviceCombSwaggerHandler.registerSwagger(this.serviceID, schemas);
            }
            MicroserviceInstance microserviceInstance = RegistryHandler.buildMicroServiceInstances(this.serviceID, microservice, this.serviceCombDiscoveryProperties, this.tagsProperties);
            this.instanceID = this.serviceCombClient.registerInstance(microserviceInstance);
            if (null != this.instanceID) {
                this.serviceCombClient.autoDiscovery(this.serviceCombDiscoveryProperties.isAutoDiscovery());
                RegisterCache.setInstanceID((String)this.instanceID);
                RegisterCache.setServiceID((String)this.serviceID);
                LOGGER.info("register success,instanceID=" + this.instanceID + ";serviceID=" + this.serviceID);
                return true;
            }
        }
        catch (ServiceCombException e) {
            this.serviceCombClient.toggle();
            LOGGER.warn("register failed, will retry. please check config file. message=" + e.getMessage());
        }
        return false;
    }

    private List<String> filterSchema(Map<String, String> localSchemas) throws ServiceCombException {
        if (!this.serviceCombDiscoveryProperties.getEnvironment().equals("production")) {
            return new ArrayList<String>(localSchemas.keySet());
        }
        SchemaResponse schemas = this.serviceCombClient.getSchemas(this.serviceID);
        schemas.getSchemas().forEach(schema -> {
            if (!localSchemas.containsKey(schema.getSchemaId()) || !((String)localSchemas.get(schema.getSchemaId())).equals(schema.getSummary())) {
                LOGGER.warn("schemas {} is changed , won't registry. if want to overwrite schema please upgrade version.", (Object)schema.getSchemaId());
            }
            localSchemas.remove(schema.getSchemaId());
        });
        return new ArrayList<String>(localSchemas.keySet());
    }

    public void deregister(ServiceCombRegistration registration) {
        this.heartbeatScheduler.remove();
        try {
            this.serviceCombClient.deRegisterInstance(RegisterCache.getServiceID(), RegisterCache.getInstanceID());
        }
        catch (ServiceCombException e) {
            LOGGER.error("deRegisterInstance failed", (Throwable)e);
        }
    }

    public void close() {
        LOGGER.info("close");
    }

    public void setStatus(ServiceCombRegistration registration, String status) {
        try {
            this.serviceCombClient.updateInstanceStatus(this.serviceID, this.instanceID, status);
        }
        catch (ServiceCombException e) {
            LOGGER.error("setStatus failed", (Throwable)e);
        }
    }

    public String getStatus(ServiceCombRegistration registration) {
        try {
            MicroserviceInstanceSingleResponse instance = this.serviceCombClient.getInstance(this.serviceID, this.instanceID);
            if (instance != null && instance.getInstance() != null) {
                return instance.getInstance().getStatus().name();
            }
        }
        catch (ServiceCombException e) {
            LOGGER.error("getStatus failed", (Throwable)e);
        }
        return null;
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public String getInstanceID() {
        return this.instanceID;
    }
}

