/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.registry;

import com.huaweicloud.common.cache.TokenCache;
import com.huaweicloud.common.exception.ServiceCombRuntimeException;
import com.huaweicloud.common.transport.BackOff;
import com.huaweicloud.common.transport.ServiceCombSSLProperties;
import com.huaweicloud.common.util.SecretUtil;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryProperties;
import com.huaweicloud.servicecomb.discovery.event.ServerCloseEvent;
import com.huaweicloud.servicecomb.discovery.event.ServiceCombEventBus;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombWebSocketClient;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.java_websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ServiceCombWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombWatcher.class);
    private static final String SSL_PREFIX = "wss://";
    private static final String DEFAULT_PREFIX = "ws://";
    private ServiceCombEventBus eventBus;
    private ServiceCombSSLProperties serviceCombSSLProperties;
    private ServiceCombDiscoveryProperties serviceCombDiscoveryProperties;
    private String url;
    private BackOff backOff = new BackOff(15000);
    private SSLContext sslContext;
    private WebSocketClient webSocketClient;
    private ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r);
        thread.setName("com.huaweicloud.servercenter.watch");
        thread.setDaemon(true);
        return thread;
    });

    public ServiceCombWatcher(ServiceCombEventBus eventBus, ServiceCombSSLProperties serviceCombSSLProperties, ServiceCombDiscoveryProperties serviceCombDiscoveryProperties) {
        this.eventBus = eventBus;
        this.serviceCombSSLProperties = serviceCombSSLProperties;
        this.serviceCombDiscoveryProperties = serviceCombDiscoveryProperties;
    }

    public void start(String url) {
        if (this.serviceCombDiscoveryProperties.getAddress().contains("https")) {
            this.url = SSL_PREFIX + url;
            this.initSSL();
        } else {
            this.url = DEFAULT_PREFIX + url;
        }
        this.connect();
        this.eventBus.register(event -> {
            if (!(event instanceof ServerCloseEvent)) {
                return;
            }
            LOGGER.info("retrying to establish websocket connecting.");
            this.connect();
        });
    }

    public synchronized void connect() {
        this.EXECUTOR.execute(() -> {
            try {
                if (this.webSocketClient == null) {
                    this.webSocketClient = this.buildClient();
                    this.webSocketClient.connect();
                } else {
                    if (this.webSocketClient.isOpen()) {
                        return;
                    }
                    this.webSocketClient.reconnect();
                }
            }
            catch (IllegalStateException e) {
                LOGGER.debug("establish websocket connect failed.", (Throwable)e);
                return;
            }
            this.backOff.waitingAndBackoff();
        });
    }

    private void initSSL() {
        this.sslContext = SecretUtil.getSSLContext((ServiceCombSSLProperties)this.serviceCombSSLProperties);
        try {
            this.sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
        }
        catch (KeyManagementException e) {
            LOGGER.error("websocket ssl init failed.");
        }
    }

    private WebSocketClient buildClient() {
        ServiceCombWebSocketClient webSocketClient;
        HashMap<String, String> signedHeader = new HashMap<String, String>();
        signedHeader.put("x-domain-name", "default");
        if (StringUtils.isEmpty((Object)TokenCache.getToken())) {
            signedHeader.put("Authorization", "Bearer " + TokenCache.getToken());
        }
        try {
            webSocketClient = new ServiceCombWebSocketClient(this.url, signedHeader, this.eventBus::publish);
        }
        catch (URISyntaxException e) {
            throw new ServiceCombRuntimeException("parse webSocketClient url error");
        }
        if (this.sslContext != null) {
            webSocketClient.setSocketFactory(this.sslContext.getSocketFactory());
        }
        return webSocketClient;
    }
}

