/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.ribbon;

import com.huaweicloud.servicecomb.discovery.client.ServiceCombClient;
import com.huaweicloud.servicecomb.discovery.client.model.Microservice;
import com.huaweicloud.servicecomb.discovery.client.model.MicroserviceInstanceStatus;
import com.huaweicloud.servicecomb.discovery.discovery.MicroserviceHandler;
import com.huaweicloud.servicecomb.discovery.discovery.ServiceCombDiscoveryProperties;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;

public class ServiceCombServerList
extends AbstractServerList<Server> {
    private ServiceCombClient serviceCombClient;
    private ServiceCombDiscoveryProperties serviceCombDiscoveryProperties;
    private String serviceId;

    public ServiceCombServerList(ServiceCombDiscoveryProperties serviceCombDiscoveryProperties, ServiceCombClient serviceCombClient) {
        this.serviceCombDiscoveryProperties = serviceCombDiscoveryProperties;
        this.serviceCombClient = serviceCombClient;
    }

    public void initWithNiwsConfig(IClientConfig iClientConfig) {
        this.serviceId = iClientConfig.getClientName();
    }

    public List<Server> getInitialListOfServers() {
        return Collections.emptyList();
    }

    public List<Server> getUpdatedListOfServers() {
        Microservice microService = MicroserviceHandler.createMicroservice(this.serviceCombDiscoveryProperties, this.serviceId);
        List<ServiceInstance> instanceList = MicroserviceHandler.getInstances(microService, this.serviceCombClient);
        return this.transform(instanceList);
    }

    private List<Server> transform(List<ServiceInstance> instanceList) {
        ArrayList<Server> serverList = new ArrayList<Server>();
        instanceList.forEach(instance -> {
            if (((String)instance.getMetadata().get(ServiceCombClient.INSTANCE_STATUS)).equals(MicroserviceInstanceStatus.UP.name())) {
                Server server = new Server(instance.getHost(), instance.getPort());
                if (instance.getMetadata().containsKey(ServiceCombClient.ZONE)) {
                    server.setZone((String)instance.getMetadata().get(ServiceCombClient.ZONE));
                }
                serverList.add(server);
            }
        });
        return serverList;
    }
}

