/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.db;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.CentralStore;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.PdqServiceThreadProvider;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.SqlStatementKey;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.xml.DOMUtil;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.binder.StatementBinderHelper;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XmlFileHelper {
    private ConnectionExecutionHandler connHandler_;
    private Transformer xmlTransformer_;
    private DocumentBuilder docBuilder_;
    private Document dom_;
    private Element rootElement_;
    private Map<String, Element> statementSetsForPackages_ = new HashMap<String, Element>();
    static DateFormat simpleDFormat_ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public static ClassLoader changeContextClassLoader(ClassLoader classLoader, boolean bl2) {
        ClassLoader classLoader2 = XmlFileHelper.getContextClassloader();
        if (null != classLoader2) {
            XmlFileHelper.setContextClassloader(classLoader);
        } else {
            Logger logger = Log.getClientOptimizerLogger();
            if (bl2 && logger.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger, XmlFileHelper.class, "changeContextClassLoader()", "currentThread ().getContextClassLoader () returned null - classLoader for XmlFileHelper: " + classLoader);
            }
        }
        return classLoader2;
    }

    public XmlFileHelper(ConnectionExecutionHandler connectionExecutionHandler) throws SQLException {
        this.connHandler_ = connectionExecutionHandler;
        ClassLoader classLoader = null;
        try {
            classLoader = XmlFileHelper.changeContextClassLoader(this.getClass().getClassLoader(), true);
            this.docBuilder_ = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.xmlTransformer_ = TransformerFactory.newInstance().newTransformer();
            this.xmlTransformer_.setOutputProperty("indent", "yes");
            this.xmlTransformer_.setOutputProperty("method", "xml");
            this.xmlTransformer_.setOutputProperty("encoding", "utf-8");
            this.xmlTransformer_.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        }
        catch (TransformerException transformerException) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_INTIALIZING_CAPTURE_STATEMENT_CLASS", new Object[0]), null, transformerException, 10461);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_INTIALIZING_CAPTURE_STATEMENT_CLASS", new Object[0]), null, parserConfigurationException, 11095);
        }
        finally {
            if (null != classLoader) {
                XmlFileHelper.setContextClassloader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocumentParserX(CentralStoreKey centralStoreKey) throws SAXException, IOException, SQLException {
        ClassLoader classLoader = null;
        try {
            Document document;
            classLoader = XmlFileHelper.changeContextClassLoader(this.getClass().getClassLoader(), false);
            InputStream inputStream = centralStoreKey.getTempInputStreamHold();
            if (inputStream == null) {
                inputStream = CentralStore.fetchFromCentralStore(CentralStore.CentralStoreFlags.FETCH_XML_FILE, centralStoreKey, null);
            }
            if (inputStream == null) {
                if (centralStoreKey.getExceptionChain() == null) {
                    throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_NOENT", new Object[0]), null, null, 10901);
                }
                throw centralStoreKey.getExceptionChain();
            }
            Document document2 = document = this.docBuilder_.parse(inputStream);
            return document2;
        }
        finally {
            if (null != classLoader) {
                XmlFileHelper.setContextClassloader(classLoader);
            }
        }
    }

    public Document getDocumentParser(CentralStoreKey centralStoreKey) throws SAXException, IOException, SQLException {
        Object[] objectArray;
        if (this.connHandler_ == null || centralStoreKey.getKeyType() == CentralStoreKey.CentralStoreKeyType.FILE_SYSTEM) {
            return this.getDocumentParserX(centralStoreKey);
        }
        if (CentralStore.willLogRepositoryConnection()) {
            CentralStore.logRepositoryConnection(centralStoreKey, "Repository, getDocumentParser", DataLogger.getShortName(this), 5);
        }
        if ((objectArray = PdqServiceThreadProvider.executeOnServiceThreadIfNeeded(PdqServiceThreadProvider.ServiceThreadRequest.GET_DOCUMENT_PARSER_WITH_KEY, this.connHandler_, this.connHandler_.isSaveServiceThread(), this, centralStoreKey))[1] != null) {
            if (objectArray[1] instanceof SQLException) {
                throw (SQLException)objectArray[1];
            }
            if (objectArray[1] instanceof SAXException) {
                throw (SAXException)objectArray[1];
            }
            if (objectArray[1] instanceof IOException) {
                throw (IOException)objectArray[1];
            }
            if (objectArray[1] instanceof RuntimeException) {
                throw (RuntimeException)objectArray[1];
            }
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_ST_ERR_PROCESSING_REPOSITORY", new Object[0]), (Throwable)objectArray[1], 11057);
        }
        return (Document)objectArray[0];
    }

    public void printToFile(Document document, CentralStoreKey centralStoreKey, BufferedWriter bufferedWriter) throws SQLException {
        ClassLoader classLoader = null;
        CentralStoreKey centralStoreKey2 = null;
        try {
            classLoader = XmlFileHelper.changeContextClassLoader(this.getClass().getClassLoader(), false);
            if (bufferedWriter == null) {
                SQLException sQLException;
                centralStoreKey2 = centralStoreKey.cloneKey();
                centralStoreKey2.setRepositoryFileInfoKey(centralStoreKey.getRepositoryFileInfoKey());
                bufferedWriter = CentralStore.writeToCentralStore(CentralStore.CentralStoreFlags.WRITE_XML_FILE, centralStoreKey2, null);
                if (bufferedWriter == null && (sQLException = centralStoreKey2.getExceptionChain()) != null) {
                    throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_WRITING_TO_CAPTURE_FILE", new Object[0]), null, sQLException, 10471);
                }
            }
            this.xmlTransformer_.transform(new DOMSource(document), new StreamResult(bufferedWriter));
        }
        catch (TransformerException transformerException) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_WRITING_TO_CAPTURE_FILE", new Object[0]), null, transformerException, 10469);
        }
        finally {
            if (null != classLoader) {
                XmlFileHelper.setContextClassloader(classLoader);
            }
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    bufferedWriter = null;
                }
            }
            catch (IOException iOException) {
                if (centralStoreKey != null) {
                    try {
                        centralStoreKey.closeCon();
                    }
                    catch (Exception exception) {}
                }
                if (centralStoreKey2 != null) {
                    try {
                        centralStoreKey2.closeCon();
                    }
                    catch (Exception exception) {}
                }
                if (centralStoreKey != null && centralStoreKey2 != null) {
                    centralStoreKey.setRepositoryFileInfoKey(centralStoreKey2.getRepositoryFileInfoKey());
                }
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_WRITING_TO_CAPTURE_FILE", new Object[0]), null, iOException, 10892);
            }
            if (centralStoreKey != null) {
                try {
                    centralStoreKey.closeCon();
                }
                catch (Exception exception) {}
            }
            if (centralStoreKey2 != null) {
                try {
                    centralStoreKey2.closeCon();
                }
                catch (Exception exception) {}
            }
            if (centralStoreKey != null && centralStoreKey2 != null) {
                centralStoreKey.setRepositoryFileInfoKey(centralStoreKey2.getRepositoryFileInfoKey());
            }
        }
    }

    public boolean printToFileIfChanged(Document document, CentralStoreKey centralStoreKey, BufferedWriter bufferedWriter) throws SQLException, IOException {
        boolean bl2 = false;
        bl2 = this.contentChanged(document, centralStoreKey);
        if (bl2) {
            this.printToFile(document, centralStoreKey, bufferedWriter);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contentChanged(Document document, CentralStoreKey centralStoreKey) throws SQLException, IOException {
        CentralStoreKey centralStoreKey2 = new CentralStoreKey(centralStoreKey.getComposedResourceString(), null, false, null);
        boolean bl2 = false;
        Class<XmlFileHelper> clazz = XmlFileHelper.class;
        synchronized (XmlFileHelper.class) {
            try {
                BufferedWriter bufferedWriter = CentralStore.writeToCentralStore(CentralStore.CentralStoreFlags.CREATE_TEMP_XML_FILE_AND_WRITE_XML, centralStoreKey2, null);
                if (bufferedWriter == null) {
                    throw centralStoreKey2.getExceptionChain();
                }
                bl2 = true;
                this.printToFile(document, centralStoreKey2, bufferedWriter);
                if (XmlFileHelper.compareFiles(centralStoreKey, centralStoreKey2)) {
                    boolean bl4 = false;
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return bl4;
                }
                boolean bl3 = true;
                // ** MonitorExit[clazz] (shouldn't be in output)
                return bl3;
            }
            finally {
                if (bl2) {
                    try {
                        CentralStore.writeToCentralStore(CentralStore.CentralStoreFlags.DELETE_TEMP_XML_FILE, centralStoreKey2, null);
                    }
                    catch (SQLException sQLException) {}
                    try {
                        centralStoreKey.closeCon();
                    }
                    catch (RuntimeException runtimeException) {
                        centralStoreKey2.closeCon();
                        throw runtimeException;
                    }
                    centralStoreKey2.closeCon();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compareFiles(CentralStoreKey centralStoreKey, CentralStoreKey centralStoreKey2) throws SQLException, IOException {
        Reader reader = null;
        Reader reader2 = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        IOException iOException = null;
        try {
            inputStream = CentralStore.fetchFromCentralStore(CentralStore.CentralStoreFlags.FETCH_XML_FILE, centralStoreKey, null);
            inputStream2 = CentralStore.fetchFromCentralStore(CentralStore.CentralStoreFlags.FETCH_XML_FILE, centralStoreKey2, null);
            if (inputStream == null) {
                throw centralStoreKey.getExceptionChain();
            }
            if (inputStream2 == null) {
                throw centralStoreKey2.getExceptionChain();
            }
            reader = new InputStreamReader(inputStream, "UTF-8");
            reader2 = new InputStreamReader(inputStream2, "UTF-8");
            boolean bl2 = XmlFileHelper.compareReaders(reader, reader2);
            return bl2;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                    inputStream = null;
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            if (null != reader2) {
                try {
                    reader2.close();
                    inputStream2 = null;
                }
                catch (IOException iOException3) {
                    iOException = iOException3;
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException4) {
                    iOException = iOException4;
                }
            }
            if (null != inputStream2) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException5) {
                    iOException = iOException5;
                }
            }
            if (null != iOException) {
                throw iOException;
            }
        }
    }

    public static boolean compareReaders(Reader reader, Reader reader2) throws IOException {
        int n2;
        char[] cArray = new char[1024];
        char[] cArray2 = new char[1024];
        while ((n2 = reader.read(cArray, 0, 1024)) != -1) {
            int n3 = reader2.read(cArray2, 0, 1024);
            if (n3 != -1) {
                String string = new String(cArray, 0, n2);
                String string2 = new String(cArray2, 0, n3);
                if (string.replace("\r\n", "\n").equals(string2.replace("\r\n", "\n"))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.docBuilder_;
    }

    public String getTextValue(Element element, String string) {
        Element element2;
        String string2 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0 && (element2 = (Element)nodeList.item(0)).getFirstChild() != null) {
            string2 = element2.getFirstChild().getNodeValue();
        }
        return string2;
    }

    public void setTextValue(String string, String string2, String string3) {
        Element element;
        NodeList nodeList;
        NodeList nodeList2 = this.rootElement_.getElementsByTagName(string3);
        if (nodeList2 != null && nodeList2.getLength() > 0 && (nodeList = (element = (Element)nodeList2.item(0)).getElementsByTagName(string)) != null && nodeList.getLength() > 0) {
            element = (Element)nodeList.item(0);
            if (element.getFirstChild() != null) {
                element.getFirstChild().setNodeValue(string2);
            } else {
                Text text = this.dom_.createTextNode(string2);
                element.appendChild(text);
            }
        }
    }

    public void setAttributeValueForNode(Element element, String string, String string2) {
        if (element != null) {
            if (string2 != null) {
                element.setAttribute(string, string2);
            } else {
                element.removeAttribute(string);
            }
        }
    }

    public void setAttributeValueForNode(String string, String string2, String string3) {
        NodeList nodeList = this.rootElement_.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            if (string3 != null) {
                element.setAttribute(string2, string3);
            } else {
                element.removeAttribute(string2);
            }
        }
    }

    public static boolean isAttributeSet(Element element, String string) {
        if (null == element) {
            return false;
        }
        return XmlFileHelper.isAttributeSet(element.getAttribute(string));
    }

    public static boolean isAttributeSet(String string) {
        return StaticProfileConstants.isValueSet(string);
    }

    public static Integer getAttributeValueInteger(Element element, String string, boolean bl2, Integer n2) {
        if (null == element) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsNoLog(Messages.getText("ERR_PUREQUERYXML_INVALID_NONAME", new Object[0]), null, 10902);
        }
        String string2 = element.getAttribute(string);
        if (!XmlFileHelper.isAttributeSet(string2)) {
            if (bl2) {
                String string3 = Messages.getText("ERR_PUREQUERYXML_INVALID_NONAME", new Object[0]) + "  " + Messages.getText("ERR_INVALID_ISBINDABLE", string2, string);
                throw ExceptionFactory.createDataRuntimeExceptionForToolsNoLog(string3, null, 10903);
            }
            return n2;
        }
        try {
            int n3 = Integer.parseInt(string2);
            return n3;
        }
        catch (Exception exception) {
            String string4 = Messages.getText("ERR_PUREQUERYXML_INVALID_NONAME", new Object[0]) + "  " + Messages.getText("ERR_INVALID_ISBINDABLE", string2, string);
            throw ExceptionFactory.createDataRuntimeExceptionForToolsNoLog(string4, exception, 10904);
        }
    }

    public static TreeSet<Integer> getAttributeValueIntegerSet(Element element, Element element2, String string, boolean bl2, TreeSet<Integer> treeSet) {
        if (null == element2) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_PUREQUERYXML_INVALID_NONAME", new Object[0]), null, 11061);
        }
        String string2 = null;
        if (element2.hasAttribute(string)) {
            string2 = element2.getAttribute(string);
        }
        if (!XmlFileHelper.isAttributeSet(string2)) {
            if (bl2) {
                String string3 = Messages.getText("ERR_PUREQUERYXML_INVALID_NONAME", new Object[0]) + "  " + Messages.getText("ERR_INVALID_ISBINDABLE", string2, string);
                throw ExceptionFactory.createDataRuntimeExceptionForToolsNoLog(string3, null, 11066);
            }
            return treeSet;
        }
        return XmlFileHelper.getAttributeValueIntegerSet(element, element2.getNodeName(), string, string2);
    }

    public static TreeSet<Integer> getAttributeValueIntegerSet(Element element, String string, String string2, String string3) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        if (null != string3 && StaticProfileConstants.isValueSet(string3)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                int n2;
                String string4 = stringTokenizer.nextToken();
                try {
                    n2 = Integer.parseInt(string4.trim());
                }
                catch (Throwable throwable) {
                    String string5 = Messages.getText("ERR_PUREQUERYXML_INVALID_NONAME", new Object[0]);
                    Integer n3 = null;
                    if (null != element) {
                        n3 = XmlFileHelper.getAttributeValueInteger(element, "id", false, null);
                    }
                    if (null != n3) {
                        string5 = string5 + "  " + Messages.getText("ERR_XML_ATTRIBUTE_OF_SQL_VALUE_WRONG", n3);
                    }
                    string5 = null != string && null != string2 ? string5 + "  " + Messages.getText("ERR_XML_ATTRIBUTE_OF_ELEMENT_VALUE_WRONG_COMMA_SEPARATED_LIST_OF_INTEGERS", string, string3, string2, string4) : (null != string2 ? string5 + "  " + Messages.getText("ERR_XML_ATTRIBUTE_OF_ELEMENT_VALUE_WRONG_COMMA_SEPARATED_LIST_OF_INTEGERS_ELEMENT_NAME_UNKNOWN", string2, string3, string4) : string5 + "  " + Messages.getText("ERR_XML_ATTRIBUTE_OF_ELEMENT_VALUE_WRONG_COMMA_SEPARATED_LIST_OF_INTEGERS_ELEMENT_AND_ATTRIBUTE_NAMES_UNKNOWN", string4));
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(string5, throwable, 11062);
                }
                treeSet.add(n2);
            }
        }
        return treeSet;
    }

    public static String getIntegerSetAsString(TreeSet<Integer> treeSet) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != treeSet) {
            for (Integer n2 : treeSet) {
                if (0 < stringBuilder.length()) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(n2);
            }
        }
        return stringBuilder.toString();
    }

    public static Integer getElementTextValueInteger(Element element, Integer n2, Integer n3) {
        if (null == element) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsNoLog(Messages.getText("ERR_PUREQUERYXML_INVALID_NONAME", new Object[0]), null, 11042);
        }
        String string = element.getTextContent();
        Integer n4 = n3;
        if (StaticProfileConstants.isValueSet(string)) {
            try {
                n4 = Integer.parseInt(string.trim());
            }
            catch (Throwable throwable) {
                String string2 = Messages.getText("ERR_PUREQUERYXML_INVALID_NONAME", new Object[0]) + "  ";
                string2 = null != n2 ? string2 + Messages.getText("ERR_ELEMENT_VALUE_MUST_BE_INTEGER_ID", n2, element.getNodeName(), string) : string2 + Messages.getText("ERR_ELEMENT_VALUE_MUST_BE_INTEGER_NO_ID", element.getNodeName(), string);
                throw ExceptionFactory.createDataRuntimeExceptionForToolsNoLog(string2, throwable, 11041);
            }
        }
        return n4;
    }

    public static Element getFirstElementByTagName(Element element, String string) {
        if (null == element) {
            return null;
        }
        NodeList nodeList = element.getElementsByTagName(string);
        if (null == nodeList) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public static String getElementTextValue(Element element, String string, String string2) {
        Element element2;
        if (null == element) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsNoLog(Messages.getText("ERR_PUREQUERYXML_INVALID_NONAME", new Object[0]), null, 11040);
        }
        String string3 = string2;
        NodeList nodeList = element.getElementsByTagName(string);
        if (null != nodeList && 0 < nodeList.getLength() && null != (element2 = (Element)nodeList.item(0))) {
            string3 = element2.getTextContent();
        }
        return string3;
    }

    public synchronized void createNewXmlDocument() {
        this.dom_ = this.getDocumentBuilder().newDocument();
    }

    public synchronized void initRootElementForXmlDocument(Document document) {
        this.dom_ = document;
        this.rootElement_ = this.dom_.getDocumentElement();
    }

    public synchronized void initRootElementForXmlDocument(CentralStoreKey centralStoreKey) throws SQLException {
        try {
            if (centralStoreKey != null && (centralStoreKey.getTempInputStreamHold() != null || centralStoreKey.isInputXmlExists())) {
                this.dom_ = this.getDocumentParser(centralStoreKey);
            }
            if (this.dom_ == null) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_UNABLE_TO_INIT_DOM", centralStoreKey), null, null, 10817);
            }
        }
        catch (SAXException sAXException) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_CAPTURE_FILE_NOT_PARSEABLE", centralStoreKey), null, sAXException, 10463);
        }
        catch (IOException iOException) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_CAPTURE_FILE_NOT_FOUND", centralStoreKey), null, iOException, 10464);
        }
        catch (Exception exception) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_CAPTURE_FILE_NOT_PARSEABLE", centralStoreKey), null, exception, 10585);
        }
        finally {
            if (centralStoreKey != null) {
                centralStoreKey.closeCon();
            }
        }
        this.setRootElement();
    }

    public Element getRootElement() {
        return this.rootElement_;
    }

    public void setRootElement() {
        this.rootElement_ = this.dom_.getDocumentElement();
    }

    public Document getXmlDocument() {
        return this.dom_;
    }

    public synchronized void freeXmlResources() {
        this.rootElement_ = null;
        this.dom_ = null;
        this.xmlTransformer_ = null;
        this.docBuilder_ = null;
        this.statementSetsForPackages_ = null;
    }

    public String byteToHex(byte by2) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[]{cArray[by2 >> 4 & 0xF], cArray[by2 & 0xF]};
        return new String(cArray2);
    }

    public static byte[] getConsistencyTokenAsByteArray(String string) {
        long l10 = Long.parseLong(string.trim(), 16);
        return StatementDescriptorImpl.timestampToBytes(l10);
    }

    private Element getRootElementOrStatementSetElement(String string) {
        if (this.rootElement_ == null) {
            this.rootElement_ = this.dom_.getDocumentElement();
        }
        if (null == string) {
            return this.rootElement_;
        }
        Element element = this.statementSetsForPackages_.get(string);
        if (null == element && !this.statementSetsForPackages_.containsKey(element)) {
            NodeList nodeList = this.rootElement_.getElementsByTagName("statementSet");
            if (null != nodeList) {
                int n2 = nodeList.getLength();
                for (int i10 = 0; i10 < n2; ++i10) {
                    String string2;
                    Element element2 = (Element)nodeList.item(i10);
                    NodeList nodeList2 = element2.getElementsByTagName("package");
                    if (null == nodeList2 || 0 >= nodeList2.getLength() || !string.equals(string2 = ((Element)nodeList2.item(0)).getAttribute("name")) || null != element) continue;
                    element = element2;
                }
            }
            this.statementSetsForPackages_.put(string, element);
        }
        return element;
    }

    public PureQueryXmlFileStatistics getPureQueryXmlFileStatistics(String string) {
        int n2;
        Element element = this.getRootElementOrStatementSetElement(string);
        int n3 = 0;
        int n4 = 0;
        NodeList nodeList = element.getElementsByTagName("package");
        if (nodeList != null) {
            n3 = nodeList.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                if (XmlFileHelper.isBindable((Element)nodeList.item(n2))) continue;
                ++n4;
            }
        }
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        NodeList nodeList2 = element.getElementsByTagName("statement");
        if (nodeList2 != null) {
            int n7;
            n2 = nodeList2.getLength();
            NodeList nodeList3 = element.getElementsByTagName("statementAttributes");
            if (nodeList3 != null && (n7 = nodeList3.getLength()) > 0) {
                for (int i10 = 0; i10 < n7; ++i10) {
                    if (XmlFileHelper.isBindable((Element)nodeList3.item(i10))) continue;
                    ++n5;
                }
            }
            NodeList nodeList4 = element.getElementsByTagName("statementType");
            String string2 = null;
            int n8 = nodeList4.getLength();
            for (int i11 = 0; i11 < n8; ++i11) {
                string2 = nodeList4.item(i11).getTextContent();
                if (!StaticProfileCaptureHelper.isDDLStatementTag(string2)) continue;
                ++n6;
            }
        }
        return new PureQueryXmlFileStatistics(n3, n4, n2, n5, n6);
    }

    public int getPackageCount(String string) {
        int n2 = 0;
        Element element = this.getRootElementOrStatementSetElement(string);
        NodeList nodeList = element.getElementsByTagName("package");
        if (nodeList != null && nodeList.getLength() > 0) {
            n2 = nodeList.getLength();
        }
        return n2;
    }

    public boolean userCaresAboutSpecialRegistersInThisFile(boolean bl2) {
        if (bl2) {
            return true;
        }
        Element element = this.getRootElement();
        NodeList nodeList = element.getElementsByTagName("package");
        int n2 = nodeList.getLength();
        for (int i10 = 0; i10 < n2; ++i10) {
            Element element2 = (Element)nodeList.item(i10);
            if (!XmlFileHelper.isAttributeSet(element2, "SQLGroupedBySpecialRegisters")) continue;
            return true;
        }
        return false;
    }

    public boolean isPackageInPureQueryXml(String string) {
        if (null == string) {
            return true;
        }
        Element element = this.getRootElementOrStatementSetElement(string);
        NodeList nodeList = element.getElementsByTagName("package");
        if (nodeList != null) {
            int n2 = nodeList.getLength();
            for (int i10 = 0; i10 < n2; ++i10) {
                String string2 = ((Element)nodeList.item(i10)).getAttribute("name");
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public String getBasePackageNameForStatementSetIndex(int n2) {
        String string = null;
        NodeList nodeList = this.rootElement_.getElementsByTagName("package");
        if (n2 <= nodeList.getLength()) {
            string = ((Element)nodeList.item(n2)).getAttribute("name");
        }
        return string;
    }

    public static String getProcessedSql(Element element) {
        return XmlFileHelper.getElementTextValue(element, "processedSql", null);
    }

    public int getStatementCount(String string) {
        int n2 = 0;
        Element element = this.getRootElementOrStatementSetElement(string);
        NodeList nodeList = element.getElementsByTagName("statement");
        if (nodeList != null && nodeList.getLength() > 0) {
            n2 = nodeList.getLength();
        }
        return n2;
    }

    public int getStatementCountForStatementSetIndex(int n2) {
        int n3 = 0;
        NodeList nodeList = this.rootElement_.getElementsByTagName("statementSet");
        if (n2 <= nodeList.getLength()) {
            NodeList nodeList2 = null;
            nodeList2 = ((Element)nodeList.item(n2)).getElementsByTagName("statement");
            if (nodeList2 != null && nodeList2.getLength() > 0) {
                n3 = nodeList2.getLength();
            }
        }
        return n3;
    }

    public void migrateAndWriteToFile(CentralStoreKey centralStoreKey, BufferedWriter[] bufferedWriterArray, boolean bl2, String string) throws SQLException {
        int n2 = this.getPureQueryXmlVersion();
        if (n2 == 4) {
            return;
        }
        if (n2 == 1) {
            NodeList nodeList = this.getRootElement().getElementsByTagName("statement");
            int n3 = nodeList.getLength();
            for (int i10 = 0; i10 < n3; ++i10) {
                Element element;
                Element element2;
                Element element3 = (Element)nodeList.item(i10);
                Element element4 = (Element)element3.getElementsByTagName("traceInfo").item(0);
                if (element4 != null) {
                    element2 = this.checkAndCreateTraceType(element4);
                    element4.appendChild(element2);
                }
                if ((element = (Element)(element2 = (Element)element3.getElementsByTagName("statementMetadata").item(0)).getElementsByTagName("processedSql").item(0)) != null) continue;
                element2.appendChild(this.getXmlDocument().createElement("processedSql"));
            }
            this.getRootElement().setAttribute("version", "2");
            n2 = 2;
        }
        if (n2 == 2) {
            this.migrateToVersion3(string);
            n2 = 3;
        }
        if (n2 == 3) {
            this.migrateToVersion4(string);
        }
        if (bl2) {
            try {
                this.printToFileIfChanged(this.getXmlDocument(), centralStoreKey, bufferedWriterArray[0]);
            }
            catch (IOException iOException) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_WRITING_TO_CAPTURE_FILE", new Object[0]), null, iOException, 11030);
            }
        }
    }

    private void migrateToVersion4(String string) {
        if (string == "IncrementalCapture") {
            NodeList nodeList = this.getRootElement().getElementsByTagName("statement");
            String string2 = XmlFileHelper.getXMLTimeStampString();
            int n2 = nodeList.getLength();
            for (int i10 = 0; i10 < n2; ++i10) {
                Element element = (Element)((Element)nodeList.item(i10)).getElementsByTagName("captureStatistics").item(0);
                Element element2 = this.getXmlDocument().createElement("lastUsedTimestamp");
                element2.setTextContent(string2);
                element.appendChild(element2);
            }
            this.getRootElement().setAttribute("xmlns", "http://www.ibm.com/xmlns/prod/optim/pureQuery/programSetV4");
            this.getRootElement().setAttribute("version", "4");
        }
    }

    public static String getXMLTimeStampString() {
        return XmlFileHelper.getXMLTimeStampString(new GregorianCalendar());
    }

    public static synchronized String getXMLTimeStampString(GregorianCalendar gregorianCalendar) {
        simpleDFormat_.setCalendar(gregorianCalendar);
        String string = simpleDFormat_.format(gregorianCalendar.getTimeInMillis());
        string = string.substring(0, 26) + ":" + string.substring(26);
        return string;
    }

    private void removeMetaDataAttrIfNotNeeded(Element element) {
        String string;
        if (element.hasAttribute("ccsid") && (string = element.getAttribute("ccsid")).equals("0")) {
            element.removeAttribute("ccsid");
        }
        if (element.hasAttribute("columnLabel") && (string = element.getAttribute("columnLabel")).equals("")) {
            element.removeAttribute("columnLabel");
        }
        if (element.hasAttribute("columnName") && (string = element.getAttribute("columnName")).equals("")) {
            element.removeAttribute("columnName");
        }
        if (element.hasAttribute("columnNameX") && (string = element.getAttribute("columnNameX")).equals("")) {
            element.removeAttribute("columnNameX");
        }
        if (element.hasAttribute("databaseName") && (string = element.getAttribute("databaseName")).equals("")) {
            element.removeAttribute("databaseName");
        }
        if (element.hasAttribute("databaseSchema") && (string = element.getAttribute("databaseSchema")).equals("")) {
            element.removeAttribute("databaseSchema");
        }
        if (element.hasAttribute("db2type") && (string = element.getAttribute("db2type")).equals("")) {
            element.removeAttribute("db2type");
        }
        if (element.hasAttribute("length") && (string = element.getAttribute("length")).equals("0")) {
            element.removeAttribute("length");
        }
        if (element.hasAttribute("optimisticLock") && (string = element.getAttribute("optimisticLock")).equals("0")) {
            element.removeAttribute("optimisticLock");
        }
        if (element.hasAttribute("parameterMode") && (string = element.getAttribute("parameterMode")).equals("0")) {
            element.removeAttribute("parameterMode");
        }
        if (element.hasAttribute("precision") && (string = element.getAttribute("precision")).equals("0")) {
            element.removeAttribute("precision");
        }
        if (element.hasAttribute("scale") && (string = element.getAttribute("scale")).equals("0")) {
            element.removeAttribute("scale");
        }
        if (element.hasAttribute("unnamedColumn") && (string = element.getAttribute("unnamedColumn")).equals("0")) {
            element.removeAttribute("unnamedColumn");
        }
        if (element.hasAttribute("updatable") && (string = element.getAttribute("updatable")).equals("0")) {
            element.removeAttribute("updatable");
        }
        if (element.hasAttribute("nullable") && (string = element.getAttribute("nullable")).equals("true")) {
            element.removeAttribute("nullable");
        }
        if (element.hasAttribute("isArray") && (string = element.getAttribute("isArray")).equals("false")) {
            element.removeAttribute("isArray");
        }
    }

    private void migrateToVersion3(String string) {
        int n2;
        Object object;
        Object object2;
        Object object3;
        Node node;
        NodeList nodeList = this.getRootElement().getElementsByTagName("statement");
        int n3 = nodeList.getLength();
        for (int i10 = 0; i10 < n3; ++i10) {
            int n4;
            Object object4;
            Element element = (Element)nodeList.item(i10);
            Element element2 = (Element)element.getElementsByTagName("statementMetadata").item(0);
            node = (Element)element2.getElementsByTagName("processedSql").item(0);
            object3 = (Element)element.getElementsByTagName("statementDescriptor").item(0);
            if (node != null) {
                object3.appendChild(node);
            } else {
                object3.appendChild(this.getXmlDocument().createElement("processedSql"));
            }
            object2 = (Element)object3.getElementsByTagName("resultSetMetadata").item(0);
            if (object2 != null) {
                object4 = object2.getElementsByTagName("column");
                int n5 = object4.getLength();
                for (n4 = 0; n4 < n5; ++n4) {
                    Element element3 = (Element)object4.item(n4);
                    this.removeMetaDataAttrIfNotNeeded(element3);
                }
            }
            if ((object4 = (Element)object3.getElementsByTagName("parameterMetadata").item(0)) != null) {
                NodeList nodeList2 = object4.getElementsByTagName("parameter");
                n4 = nodeList2.getLength();
                for (int i11 = 0; i11 < n4; ++i11) {
                    Element element4 = (Element)nodeList2.item(i11);
                    this.removeMetaDataAttrIfNotNeeded(element4);
                }
            }
            if (SqlStatementType.getSqlStatementType((String)(object = element.getElementsByTagName("statementType").item(0).getTextContent())).equals((Object)SqlStatementType.MERGE) && string != "IncrementalCapture") {
                Element element5 = (Element)element.getElementsByTagName("statementAttributes").item(0);
                element5.setAttribute("parameterType", "MULTI_ROW_PARAMETERS");
            }
            this.createReservedSectionsInDOM(element, string);
        }
        NodeList nodeList3 = this.getRootElement().getElementsByTagName("statementSet");
        int n6 = nodeList3.getLength();
        for (n2 = 0; n2 < n6; ++n2) {
            node = nodeList3.item(n2);
            if (((Element)node).hasAttribute("configureStatus")) continue;
            ((Element)node).setAttribute("configureStatus", "AUTO");
        }
        if (string != "IncrementalCapture") {
            for (n2 = 0; n2 < n3; ++n2) {
                node = (Element)nodeList.item(n2);
                object3 = XmlFileHelper.getUpdatableCursorName(node);
                if (object3 == null || ((String)object3).length() == 0) continue;
                object2 = XmlFileHelper.getCursorKeyAsUsedByReferencedQueries((Element)node, null);
                for (int i12 = n2 + 1; i12 < n3; ++i12) {
                    object = (Element)nodeList.item(i12);
                    Element element = (Element)object.getElementsByTagName("statementAttributes").item(0);
                    String string2 = null;
                    if (element.hasAttribute("positionedUpdateCursor")) {
                        string2 = element.getAttribute("positionedUpdateCursor");
                    }
                    if (string2 == null || !string2.equals(object3)) continue;
                    element.setAttribute("referencedQuery", (String)object2);
                }
            }
        }
        this.getRootElement().setAttribute("xmlns", "http://www.ibm.com/xmlns/prod/optim/pureQuery/programSetV3");
        this.getRootElement().setAttribute("version", "3");
    }

    public void createReservedSectionsInDOM(Element element, String string) {
        if (XmlFileHelper.checkIfReservedSectionReqdForInsertMRI(element)) {
            if (string.equals("IncrementalCapture")) {
                element.setAttribute("numReservedSections", "1");
            } else {
                element.setAttribute("numReservedSections", "2");
            }
        } else if (XmlFileHelper.checkIfReservedSectionReqdForMergeMRI(element)) {
            if (!string.equals("IncrementalCapture")) {
                element.setAttribute("numReservedSections", "1");
            }
        } else if (XmlFileHelper.checkIfReservedSectionReqdForPosUpdt(element)) {
            element.setAttribute("numReservedSections", "1");
        }
    }

    public static int countReservedSectionsReqd(Element element) {
        if (XmlFileHelper.checkIfReservedSectionReqdForPosUpdt(element)) {
            return 1;
        }
        if (XmlFileHelper.checkIfReservedSectionReqdForMergeMRI(element)) {
            return 1;
        }
        if (XmlFileHelper.checkIfReservedSectionReqdForInsertMRI(element)) {
            return 2;
        }
        return 0;
    }

    public static boolean checkIfReservedSectionReqdForMergeMRI(Element element) {
        if (element.getElementsByTagName("statementType").item(0).getTextContent().equals("MERGE")) {
            Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
            return StaticProfileConstants.isCandidateForStaticMRI_configureTimeCheck(element2.getAttribute("parameterType"), StaticProfileConstants.areAutoGeneratedKeysRequested(element));
        }
        return false;
    }

    public static boolean checkIfReservedSectionReqdForInsertMRI(Element element) {
        Element element2;
        if (element.getElementsByTagName("statementType").item(0).getTextContent().equals("INSERT") && StaticProfileConstants.isCandidateForStaticMRI_configureTimeCheck((element2 = (Element)element.getElementsByTagName("statementAttributes").item(0)).getAttribute("parameterType"), StaticProfileConstants.areAutoGeneratedKeysRequested(element))) {
            return !XmlFileHelper.checkIfInsertWithSelect(element);
        }
        return false;
    }

    public static boolean checkIfReservedSectionReqdForPosUpdt(Element element) {
        return XmlFileHelper.getUpdatableCursorName(element) != null;
    }

    private static boolean checkIfInsertWithSelect(Node node) {
        String string = ((Element)node).getElementsByTagName("prepareSql").item(0).getTextContent();
        Matcher matcher = StaticProfileConstants.InsertValuesPat.matcher(string = EscapeLexer.filterComments(string, true));
        if (matcher.find()) {
            return false;
        }
        matcher = StaticProfileConstants.InsertSelectPat.matcher(string);
        return matcher.find();
    }

    public static String getCursorKeyAsUsedByReferencedQueries(Element element, Element element2) {
        NodeList nodeList;
        if (null == element2 && 0 < (nodeList = element.getElementsByTagName("statementAttributes")).getLength()) {
            element2 = (Element)nodeList.item(0);
        }
        boolean bl2 = null != element2 && XmlFileHelper.isAttributeSet(element2, "cursorName");
        String string = null;
        if (bl2) {
            SqlStatementKey sqlStatementKey = SqlStatementKey.generateStmtKey(element);
            string = sqlStatementKey.toString();
        }
        return string;
    }

    public static String getUpdatableCursorName(Node node) {
        String string = null;
        String string2 = null;
        String string3 = null;
        Element element = DOMUtil.getFirstChildByName(node, "statementDescriptor");
        Element element2 = DOMUtil.getFirstChildByName(element, "statementAttributes");
        if (element2.hasAttribute("cursorName") && element2.getAttribute("cursorName").length() > 0) {
            string = element2.getAttribute("cursorName");
        }
        if (string == null) {
            return null;
        }
        String string4 = DOMUtil.getFirstValueByName(element, "statementType");
        if (string4.equals("QUERY")) {
            int n2 = XmlTags.getConcurrencyNumber(element2.getAttribute("resultSetConcurrency"));
            if (1008 == n2) {
                string2 = string;
            } else {
                Matcher matcher;
                Element element3 = DOMUtil.getFirstChildByName(element, "processedSql");
                if (element3 != null && ((string3 = element3.getTextContent()) == null || string3.length() == 0)) {
                    string3 = DOMUtil.getFirstValueByName(element, "prepareSql");
                }
                if (string3 != null && (matcher = StaticProfileConstants.forUpdateOfPat.matcher(string3 = EscapeLexer.filterComments(string3, true))).find()) {
                    string2 = string;
                }
            }
        }
        return string2;
    }

    public String checkIfStmtHasPosUpdateCursor(Element element) {
        Element element2 = DOMUtil.getFirstChildByName(element, "statementDescriptor");
        Element element3 = DOMUtil.getFirstChildByName(element2, "statementAttributes");
        if (element3.hasAttribute("positionedUpdateCursor")) {
            return element3.getAttribute("positionedUpdateCursor");
        }
        return null;
    }

    public boolean verifyFileContents() {
        Element element = DOMUtil.getFirstChildByName(this.getRootElement(), "origin");
        if (element == null) {
            return false;
        }
        Element element2 = DOMUtil.getFirstChildByName(element, "originType");
        return element2 != null;
    }

    private Element checkAndCreateTraceType(Element element) {
        Node node;
        int n2;
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagName("traceEntry");
        String string = ((Element)nodeList.item(0)).getAttribute("method");
        element2 = string.equals("addBatch") || string.equals("addDBBatch") ? this.getXmlDocument().createElement("sqlDefinitionStackTraces") : this.getXmlDocument().createElement("sqlExecutionStackTraces");
        Element element3 = this.getXmlDocument().createElement("trace");
        int n3 = nodeList.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (n2 = 0; n2 < n3; ++n2) {
            node = nodeList.item(n2);
            arrayList.add(node);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            node = element.removeChild((Node)arrayList.get(n2));
            element3.appendChild(node);
        }
        element2.appendChild(element3);
        return element2;
    }

    public boolean checkIfAnyStatementSetNeedsToBeConfigured() {
        int n2 = this.getPureQueryXmlVersion();
        boolean bl2 = 3 <= n2;
        boolean bl3 = false;
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(this.getRootElement(), "statementSet");
        for (int i10 = 0; i10 < arrayList.size() && !bl3; ++i10) {
            Element element = arrayList.get(i10);
            if (bl2 && StatementBinderHelper.ConfigureStatusValues.REQUIRED == StatementBinderHelper.ConfigureStatusValues.getValueOf(element.getAttribute("configureStatus"))) {
                bl3 = true;
                continue;
            }
            Element element2 = DOMUtil.getFirstChildByName(element, "package");
            if (!XmlFileHelper.packageIsNamed(element2)) {
                bl3 = true;
                continue;
            }
            if (XmlFileHelper.isAttributeSet(element2, "consistencyToken")) continue;
            bl3 = true;
        }
        return bl3;
    }

    public int getPureQueryXmlVersion() {
        return XmlFileHelper.getAttributeValueInteger(this.getRootElement(), "version", true, null);
    }

    public static boolean packageIsNamed(Element element) {
        return XmlFileHelper.isAttributeSet(element, "name");
    }

    public static long assignNewConsistencyTokenAndSetGreatestSectionNumberUsed(Element element, Integer n2) {
        int n3 = null != n2 ? n2 : 0;
        Element element2 = DOMUtil.getFirstChildByName(element, "package");
        element2.setAttribute("greatestSectionNumberUsed", Integer.toString(n3));
        long l10 = System.currentTimeMillis();
        String string = StatementDescriptorImpl.getTimestampAsString(l10);
        element2.setAttribute("consistencyToken", string);
        return l10;
    }

    public static BufferedInputStream getFileAsBufferedInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static final PrivilegedExceptionAction<BufferedInputStream> getFileAsBufferedInputStreamPriv(final File file) {
        return new PrivilegedExceptionAction<BufferedInputStream>(){

            @Override
            public BufferedInputStream run() throws FileNotFoundException {
                return new BufferedInputStream(new FileInputStream(file));
            }
        };
    }

    public static BufferedWriter getFileAsBufferedWriter(File file, boolean bl2, String string) throws UnsupportedEncodingException, FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl2), string));
    }

    public static final PrivilegedExceptionAction<BufferedWriter> getFileAsBufferedWriterPriv(final File file, final boolean bl2, final String string) {
        return new PrivilegedExceptionAction<BufferedWriter>(){

            @Override
            public BufferedWriter run() throws FileNotFoundException, UnsupportedEncodingException {
                return XmlFileHelper.getFileAsBufferedWriter(file, bl2, string);
            }
        };
    }

    public static boolean getIsBindableDefaultForStatement(SqlStatementType sqlStatementType) {
        if (null == sqlStatementType) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{sqlStatementType}), null, 11257);
        }
        if (SqlStatementType.isDDL(sqlStatementType)) {
            return false;
        }
        switch (sqlStatementType) {
            case VALUES: 
            case COMPOUND: 
            case SET: 
            case SET_METHOD: 
            case XQUERY: {
                return false;
            }
        }
        return true;
    }

    public static boolean isBindable(Element element) {
        if (null == element) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsNoLog(Messages.getText("ERR_PUREQUERYXML_INVALID_NONAME", new Object[0]), null, 11073);
        }
        if (element.hasAttribute("isBindable")) {
            return "true".equalsIgnoreCase(element.getAttribute("isBindable"));
        }
        return false;
    }

    public static DocumentBuilder getNewDocumentBuilder() throws SQLException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(null, Messages.getText("ERR_PROFILER_INTIALIZING_CAPTURE_STATEMENT_CLASS", new Object[0]), null, parserConfigurationException, 10462);
        }
    }

    public static ClassLoader getContextClassloader() {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader setContextClassloader(final ClassLoader classLoader) {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        return null;
    }

    public static class PureQueryXmlFileStatistics {
        private final int statementSetsTotalCount_;
        private final int statementSetsIsBindableFalseCount_;
        private final int statementsTotalCount_;
        private final int statementsIsBindableFalseCount_;
        private final int statementsDDLCount_;

        protected PureQueryXmlFileStatistics(int n2, int n3, int n4, int n5, int n6) {
            this.statementSetsTotalCount_ = n2;
            this.statementSetsIsBindableFalseCount_ = n3;
            this.statementsTotalCount_ = n4;
            this.statementsIsBindableFalseCount_ = n5;
            this.statementsDDLCount_ = n6;
        }

        public String getStatisticsString(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            this.addLineToBuffer(stringBuilder, string, Messages.getText("MSG_SHOW_DETAILS_STATICBINDERCONFIGURE_STATEMENT_SET_COUNT", this.statementSetsTotalCount_));
            this.addLineToBuffer(stringBuilder, string, Messages.getText("MSG_SHOW_DETAILS_STATICBINDERCONFIGURE_STATEMENT_SET_COUNT_ISBINDABLE_FALSE", "isBindable", "false", this.statementSetsIsBindableFalseCount_));
            this.addLineToBuffer(stringBuilder, string, Messages.getText("MSG_SHOW_DETAILS_CONFIGURE_STATEMENT_COUNT", this.statementsTotalCount_));
            this.addLineToBuffer(stringBuilder, string, Messages.getText("MSG_SHOW_DETAILS_CONFIGURE_STATEMENT_COUNT_ISBINDABLE_FALSE", "isBindable", "false", this.statementsIsBindableFalseCount_));
            this.addLineToBuffer(stringBuilder, string, Messages.getText("MSG_SHOW_DETAILS_STATICBINDERCONFIGURE_DDL_STATEMENT_COUNT", this.statementsDDLCount_));
            return stringBuilder.toString();
        }

        private void addLineToBuffer(StringBuilder stringBuilder, String string, String string2) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(XmlTags.CRLF);
            }
            stringBuilder.append(string);
            stringBuilder.append(string2);
        }
    }
}

